/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.MapMaker;

public class BiomeBasin {
    final int x;
    final int z;
    final int value;
    final double strength;
    ChunkTile center;

    public BiomeBasin(int x, int y, int value, double strength) {
        this.x = x;
        this.z = y;
        this.value = value;
        this.strength = strength;
        this.center = null;
    }

    public BiomeBasin(int x, int y, int value, double strength, MapMaker map) {
        this.x = x;
        this.z = y;
        this.value = value;
        this.strength = strength;
        this.center = map.getTile(x, y);
        this.center.biomeSeed = value;
    }

    public double getWeaknessAt(int atx, int aty) {
        double xdisplace = this.x - atx;
        double ydisplace = this.z - aty;
        return xdisplace * xdisplace + ydisplace * ydisplace;
    }

    public static void summateEffect(BiomeBasin[][] n, ChunkTile t) {
        double effect = 0.0;
        int indexx = 0;
        int indexy = 0;
        for (int i = 0; i < n.length; ++i) {
            for (int j = 0; j < n[i].length; ++j) {
                double power = n[i][j].strength / n[i][j].getWeaknessAt(t.x, t.z);
                if (!(effect < power)) continue;
                effect = power;
                indexx = i;
                indexy = j;
            }
        }
        t.centrality = Math.max(1.0 - Math.sqrt(n[indexx][indexy].getWeaknessAt(t.x, t.z)) / n[indexx][indexy].strength / 8.0, 0.0);
        t.biomeSeed = n[indexx][indexy].value & Integer.MAX_VALUE;
    }

    public static int summateEffect(BiomeBasin[][] n, int x, int z) {
        double effect = 0.0;
        int indexx = 0;
        int indexy = 0;
        for (int i = 0; i < n.length; ++i) {
            for (int j = 0; j < n[i].length; ++j) {
                double power = n[i][j].strength / n[i][j].getWeaknessAt(x, z);
                if (!(effect < power)) continue;
                effect = power;
                indexx = i;
                indexy = j;
            }
        }
        return n[indexx][indexy].value;
    }

    public static ChunkTile summateForCenter(BiomeBasin[][] n, ChunkTile t) {
        double effect = 0.0;
        int indexx = 0;
        int indexy = 0;
        for (int i = 0; i < n.length; ++i) {
            for (int j = 0; j < n[i].length; ++j) {
                double power = n[i][j].strength / n[i][j].getWeaknessAt(t.x, t.z);
                if (!(effect < power)) continue;
                effect = power;
                indexx = i;
                indexy = j;
            }
        }
        t.centrality = Math.max(1.0 - Math.sqrt(n[indexx][indexy].getWeaknessAt(t.x, t.z)) / n[indexx][indexy].strength / 8.0, 0.0);
        return n[indexx][indexy].center;
    }

    public static ChunkTile summateForCenter(BiomeBasin[][] n, int x, int z) {
        double effect = 0.0;
        int indexx = 0;
        int indexy = 0;
        for (int i = 0; i < n.length; ++i) {
            for (int j = 0; j < n[i].length; ++j) {
                double power = n[i][j].strength / n[i][j].getWeaknessAt(x, z);
                if (!(effect < power)) continue;
                effect = power;
                indexx = i;
                indexy = j;
            }
        }
        return n[indexx][indexy].center;
    }
}

