/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.chunk;

import jaredbgreat.climaticbiome.generation.cache.AbstractWeaklyCacheable;
import jaredbgreat.climaticbiome.generation.chunk.VolumnMapManager;
import jaredbgreat.climaticbiome.util.ModMath;
import jaredbgreat.climaticbiome.util.SpatialHash;
import jaredbgreat.climaticbiome.util.VolumnNoiseMap;

public class VolumnMapArea
extends AbstractWeaklyCacheable {
    public static final int CSIZE = 8;
    public static final int BSIZE = 16;
    public static final int SCALE = 192;
    private final VolumnNoiseMap noiseMap;

    public VolumnMapArea(int x, int z, SpatialHash rand, VolumnMapManager manager) {
        super(x, z, manager.getCache());
        this.noiseMap = new VolumnNoiseMap(16, 16, 16, 8, 32, 8, 16, 192.0f).process(rand, x * 16, z * 16);
    }

    public int[] getChunkHieghts(int x, int z, float[] biomeData) {
        int[] out = new int[65536];
        int startx = ModMath.modRight(x, 8) * 16;
        int startz = ModMath.modRight(z, 8) * 16;
        int endx = startx + 16;
        int endz = startz + 16;
        int ix = 0;
        int jz = 0;
        int i = startx;
        while (i < endx) {
            jz = 0;
            int j = startz;
            while (j < endz) {
                int index1 = ix * 16 + jz;
                for (int k = 0; k < 256; ++k) {
                    int index2 = index1 * 256 + k;
                    out[index2] = (int)(this.noiseMap.get(i, k, j) * biomeData[index1 + 256] + biomeData[index1] * 20.0f + 64.0f);
                }
                ++j;
                ++jz;
            }
            ++i;
            ++ix;
        }
        return out;
    }

    public float[] getChunkNoise(int x, int z, float[] biomeData) {
        float[] out = new float[1024];
        int startx = ModMath.modRight(x, 8) * 4;
        int startz = ModMath.modRight(z, 8) * 4;
        int endx = startx + 4;
        int endz = startz + 4;
        int ix = 0;
        int jz = 0;
        int i = startx;
        while (i < endx) {
            jz = 0;
            int j = startz;
            while (j < endz) {
                for (int k = 0; k < 64; ++k) {
                    int index2 = (ix * 4 + jz) * 64 + k;
                    out[index2] = this.noiseMap.get(i, k, j) / 192.0f * 4.0f;
                }
                ++j;
                ++jz;
            }
            ++i;
            ++ix;
        }
        return out;
    }

    public static void statArray(float[][] in, String name) {
        int j;
        int i;
        float min = Float.NEGATIVE_INFINITY;
        float max = Float.POSITIVE_INFINITY;
        float sum = 0.0f;
        float avg = 0.0f;
        float std = 0.0f;
        int num = 0;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                ++num;
                if (in[i][j] > min) {
                    min = in[i][j];
                }
                if (in[i][j] < max) {
                    max = in[i][j];
                }
                sum += in[i][j];
            }
        }
        avg = sum / (float)num;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                float tmp = in[i][j] - avg;
                std += tmp * tmp;
            }
        }
        std /= (float)num;
        std = (float)Math.sqrt(std);
        System.out.println();
        System.out.println("****************");
        System.out.println("Array Name: " + name);
        System.out.println("N = " + num);
        System.out.println("Minimum = " + min);
        System.out.println("Maximum = " + max);
        System.out.println("Total = " + sum);
        System.out.println("Mean = " + avg);
        System.out.println("Standard Deviation = " + std);
        System.out.println("****************");
        System.out.println();
    }

    public static void statArray(double[][] in, String name) {
        int j;
        int i;
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        float sum = 0.0f;
        float avg = 0.0f;
        float std = 0.0f;
        int num = 0;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                ++num;
                if (in[i][j] > min) {
                    min = in[i][j];
                }
                if (in[i][j] < max) {
                    max = in[i][j];
                }
                sum = (float)((double)sum + in[i][j]);
            }
        }
        avg = sum / (float)num;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                double tmp = in[i][j] - (double)avg;
                std = (float)((double)std + tmp * tmp);
            }
        }
        std /= (float)num;
        std = (float)Math.sqrt(std);
        System.out.println();
        System.out.println("****************");
        System.out.println("Array Name: " + name);
        System.out.println("N = " + num);
        System.out.println("Minimum = " + min);
        System.out.println("Maximum = " + max);
        System.out.println("Total = " + sum);
        System.out.println("Mean = " + avg);
        System.out.println("Standard Deviation = " + std);
        System.out.println("****************");
        System.out.println();
    }
}

