/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.chunk;

import jaredbgreat.climaticbiome.generation.ClimaticBiomeProvider;
import jaredbgreat.climaticbiome.generation.chunk.ChunkGenClimaticRealistic;
import jaredbgreat.climaticbiome.generation.chunk.IBlockSetter;
import jaredbgreat.climaticbiome.generation.chunk.VolumnMapManager;
import jaredbgreat.climaticbiome.util.SpatialHash;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class BorderTestBlockSetter
implements IBlockSetter {
    static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    private final VolumnMapManager volumnMapManager;
    private final SpatialHash sprandom;
    private final World world;

    public BorderTestBlockSetter(World world, SpatialHash sprandom) {
        this.world = world;
        this.sprandom = sprandom;
        this.volumnMapManager = new VolumnMapManager();
    }

    @Override
    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int[] volumnmap = this.getHeihtmapForChunk(x, z, this.sprandom);
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int h = volumnmap[i * 16 + k];
                for (int j = 0; j < 256; ++j) {
                    if (j < h) {
                        primer.func_177855_a(i, j, k, STONE);
                        continue;
                    }
                    if (j >= 63) continue;
                    primer.func_177855_a(i, j, k, ChunkGenClimaticRealistic.WATER);
                }
            }
        }
    }

    private int[] getHeihtmapForChunk(int x, int z, SpatialHash rand) {
        ClimaticBiomeProvider provider = (ClimaticBiomeProvider)this.world.func_72959_q();
        return this.volumnMapManager.getChunkHieghts(x, z, rand, provider.getTerrainBiomeGen(x, z));
    }
}

