/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.cache;

import jaredbgreat.climaticbiome.generation.cache.Coords;
import jaredbgreat.climaticbiome.util.SpatialHash;

public class MutableCoords {
    private static final SpatialHash NH = new SpatialHash(-1378500386L);
    private int x;
    private int z;

    public MutableCoords init(int x, int z) {
        this.x = x;
        this.z = z;
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof MutableCoords) {
            MutableCoords o = (MutableCoords)other;
            return o.x == this.x && o.z == this.z;
        }
        if (other instanceof Coords) {
            Coords o = (Coords)other;
            return o.getX() == this.x && o.getZ() == this.z;
        }
        return false;
    }

    public boolean equals(int x, int z) {
        return this.x == x && this.z == z;
    }

    public int hashCode() {
        return NH.intFor(this.x, this.z, 0);
    }

    public static int hashCoords(int x, int z) {
        return NH.intFor(x, z, 0);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }
}

