/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSwamp;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import net.minecraft.world.biome.Biome;

public class GetWarmForest
implements IBiomeSpecifier {
    private static GetWarmForest sforest;
    private BiomeList forests;
    private GetPlains plains;
    private GetSwamp swamp;

    private GetWarmForest() {
        this.init();
    }

    public void init() {
        this.forests = new BiomeList();
        this.plains = GetPlains.getPlains();
        this.swamp = GetSwamp.getSwamp();
        DefReader.readBiomeData(this.forests, "ForestWarm.cfg");
        if (this.forests.isEmpty()) {
            if (ConfigHandler.includeForests) {
                this.forests.addItem(new LeafBiome(Biome.func_185362_a((Biome)ModBiomes.warmForest)), 5);
                this.forests.addItem(new LeafBiome(Biome.func_185362_a((Biome)ModBiomes.warmForestHills)), 3);
                this.forests.addItem(new LeafBiome(Biome.func_185362_a((Biome)ModBiomes.pineWoods)));
            } else {
                this.forests.addItem(GetForest.getForest());
            }
        }
    }

    @Override
    public long getBiome(ChunkTile tile) {
        int role2 = tile.getBiomeSeed() % 7;
        int role3 = tile.getBiomeSeed() % 12;
        tile.nextBiomeSeed();
        if (role2 == 0) {
            return this.swamp.getBiome(tile);
        }
        if (role3 == 0) {
            return this.plains.getBiome(tile);
        }
        return this.forests.getBiome(tile);
    }

    public static GetWarmForest getForest() {
        if (sforest == null) {
            sforest = new GetWarmForest();
        }
        return sforest;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

