/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.SeedDoubleBiome;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetSwamp
implements IBiomeSpecifier {
    private static GetSwamp swamp;
    BiomeList cold;
    BiomeList cool;
    BiomeList warm;
    BiomeList hot;

    private GetSwamp() {
        this.init();
    }

    public void init() {
        this.cold = new BiomeList();
        this.cool = new BiomeList();
        this.warm = new BiomeList();
        this.hot = new BiomeList();
        DefReader.readBiomeData(this.cold, "SwampCold.cfg");
        DefReader.readBiomeData(this.cool, "SwampCool.cfg");
        DefReader.readBiomeData(this.warm, "SwampWarm.cfg");
        DefReader.readBiomeData(this.hot, "SwampTropical.cfg");
        if (this.warm.isEmpty()) {
            this.warm.addItem(new LeafBiome(6L), 3);
            this.warm.addItem(new LeafBiome(134L), 1);
            if (this.cool.isEmpty()) {
                this.cool.addItem(new SeedDoubleBiome(134L, 3, 6L));
            }
        }
        this.fixSwamps();
    }

    @Override
    public long getBiome(ChunkTile tile) {
        tile.setSwamp();
        int temp = tile.getTemp();
        if (temp < 12) {
            return this.cold.getBiome(tile);
        }
        if (temp < 16) {
            return this.cool.getBiome(tile);
        }
        if (temp < 21) {
            return this.warm.getBiome(tile);
        }
        return this.hot.getBiome(tile);
    }

    public static GetSwamp getSwamp() {
        if (swamp == null) {
            swamp = new GetSwamp();
        }
        return swamp;
    }

    private void fixSwamps() {
        if (this.cool.isEmpty()) {
            this.cool = this.warm;
        }
        if (this.cold.isEmpty()) {
            this.cold = this.cool;
        }
        if (this.hot.isEmpty()) {
            this.hot = this.warm;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

