/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.biomes.pseudo.PseudoBiomes;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import net.minecraft.world.biome.Biome;

public class GetRiver
implements IBiomeSpecifier {
    private static GetRiver river;
    private static int temperate;
    private static int warm;
    private static int hot;

    private GetRiver() {
    }

    @Override
    public long getBiome(ChunkTile tile) {
        tile.setSteep();
        if (ConfigHandler.includeRivers) {
            int t = tile.getTemp();
            if (t < 5) {
                return PseudoBiomes.deepFrozenRiver.getSubId();
            }
            if (t < 10) {
                return PseudoBiomes.deepRiver.getSubId();
            }
            if (t < 16) {
                return temperate;
            }
            if (t < 20) {
                return warm;
            }
            return hot;
        }
        if (tile.getTemp() + (tile.getBiomeSeed() & 1) < 5) {
            PseudoBiomes.deepFrozenRiver.getSubId();
        }
        return PseudoBiomes.deepRiver.getSubId();
    }

    public static GetRiver getRiver() {
        if (river == null) {
            river = new GetRiver();
        }
        return river;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static void initAdvanced() {
        temperate = Biome.func_185362_a((Biome)ModBiomes.river);
        warm = Biome.func_185362_a((Biome)ModBiomes.warmRiver);
        hot = Biome.func_185362_a((Biome)ModBiomes.hotRiver);
    }
}

