/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.SeedDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetJungle;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSwamp;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import net.minecraft.world.biome.Biome;

public class GetHotForest
implements IBiomeSpecifier {
    private static GetHotForest tforest;
    private BiomeList forests;
    private GetPlains plains;
    private GetSwamp swamp;

    private GetHotForest() {
        this.init();
    }

    public void init() {
        this.forests = new BiomeList();
        this.swamp = GetSwamp.getSwamp();
        DefReader.readBiomeData(this.forests, "ForestTropical.cfg");
        if (!ConfigHandler.includeForests) {
            DefReader.readBiomeData(this.forests, "Jungle.cfg");
        }
        if (this.forests.isEmpty()) {
            if (ConfigHandler.includeForests) {
                this.forests.addItem(new SeedDoubleBiome(151L, 5, 23L));
                this.forests.addItem(new LeafBiome(Biome.func_185362_a((Biome)ModBiomes.tropicalForestHills)));
                this.forests.addItem(new LeafBiome(Biome.func_185362_a((Biome)ModBiomes.tropicalForest)), 3);
            } else {
                this.forests.addItem(GetJungle.getJungle());
            }
        }
    }

    @Override
    public long getBiome(ChunkTile tile) {
        int role2 = tile.getBiomeSeed() % 7;
        tile.nextBiomeSeed();
        if (role2 == 0) {
            return this.swamp.getBiome(tile);
        }
        return this.forests.getBiome(tile);
    }

    public static GetHotForest getForest() {
        if (tforest == null) {
            tforest = new GetHotForest();
        }
        return tforest;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

