/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPlains;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetCoolPark
implements IBiomeSpecifier {
    private static GetCoolPark pland;
    private BiomeList parks;
    private GetCoolPlains plains;
    private GetCoolForest woods;

    private GetCoolPark() {
        this.init();
    }

    public void init() {
        this.parks = new BiomeList();
        this.plains = GetCoolPlains.getPlains();
        this.woods = GetCoolForest.getForest();
        DefReader.readBiomeData(this.parks, "ParklandCool.cfg");
        this.parks.addItem(this.woods);
        this.parks.addItem(this.plains);
    }

    @Override
    public long getBiome(ChunkTile tile) {
        int seed = tile.getBiomeSeed();
        if (this.parks.isEmpty() || seed % 7 == 0) {
            if ((seed & 1) == 0) {
                tile.nextBiomeSeed();
                return this.woods.getBiome(tile);
            }
            tile.nextBiomeSeed();
            return this.plains.getBiome(tile);
        }
        tile.nextBiomeSeed();
        return this.parks.getBiome(tile);
    }

    BiomeList getList() {
        return this.parks;
    }

    public static GetCoolPark getPark() {
        if (pland == null) {
            pland = new GetCoolPark();
        }
        return pland;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

