/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.SeedDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSwamp;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetCoolForest
implements IBiomeSpecifier {
    private static GetCoolForest cforest;
    private BiomeList forests;
    private GetCoolPlains plains;
    private GetSwamp swamp;

    private GetCoolForest() {
        this.init();
    }

    public void init() {
        this.forests = new BiomeList();
        this.plains = GetCoolPlains.getPlains();
        this.swamp = GetSwamp.getSwamp();
        DefReader.readBiomeData(this.forests, "ForestCool.cfg");
        if (this.forests.isEmpty()) {
            this.forests.addItem(new SeedDoubleBiome(18L, 3, 4L), 3);
            this.forests.addItem(new LeafBiome(132L), 1);
            this.forests.addItem(new SeedDoubleBiome(27L, 4, 28L), 1);
            this.forests.addItem(new SeedDoubleBiome(155L, 5, 27L), 1);
            this.forests.addItem(new SeedDoubleBiome(157L, 7, 29L), 2);
        }
    }

    @Override
    public long getBiome(ChunkTile tile) {
        int role2 = tile.getBiomeSeed() % 7;
        int role3 = tile.getBiomeSeed() % 12;
        tile.nextBiomeSeed();
        if (role2 == 0) {
            return this.swamp.getBiome(tile);
        }
        if (role3 == 0) {
            return this.plains.getBiome(tile);
        }
        return this.forests.getBiome(tile);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    BiomeList getList() {
        return this.forests;
    }

    public static GetCoolForest getForest() {
        if (cforest == null) {
            cforest = new GetCoolForest();
        }
        return cforest;
    }
}

