/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome;

import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BiomeList
implements IBiomeSpecifier {
    private final List<IBiomeSpecifier> list = new ArrayList<IBiomeSpecifier>();

    @Override
    public long getBiome(ChunkTile tile) {
        tile.nextBiomeSeed();
        try {
            return this.list.get(tile.getBiomeSeed() % this.list.size()).getBiome(tile);
        }
        catch (ArithmeticException ex) {
            Logger.getLogger("Minecraft").log(Level.SEVERE, "A biome was requested from an empty biome list!  \nAll lists must contain at least one biome (fix your configs).", ex);
            throw ex;
        }
    }

    public void addItem(IBiomeSpecifier biome, int n) {
        for (int i = 0; i < n; ++i) {
            this.list.add(biome);
        }
    }

    public void addItem(IBiomeSpecifier biome) {
        this.list.add(biome);
    }

    public void addItems(IBiomeSpecifier ... biomes) {
        for (IBiomeSpecifier biome : biomes) {
            this.list.add(biome);
        }
    }

    public void addItems(List<IBiomeSpecifier> biomes) {
        this.list.addAll(biomes);
    }

    public boolean remove(IBiomeSpecifier bs) {
        return this.list.remove(bs);
    }

    public boolean merge(BiomeList other) {
        return this.list.addAll(other.list);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }
}

