/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetAlpine;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetBeach;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetChaparral;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetColdPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPark;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetDesert;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetHotForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetJungle;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetOcean;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPark;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetRiver;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSavanna;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSwamp;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetTaiga;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetTundra;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetWarmForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetWarmPlains;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeClimateTable
implements IBiomeSpecifier {
    private static BiomeClimateTable main;
    private static LandBiomeTable land;
    private IBiomeSpecifier[] table;
    static IBiomeSpecifier OCEAN;
    static IBiomeSpecifier SWAMP;
    static IBiomeSpecifier TUNDRA;
    static IBiomeSpecifier CGRASS;
    static IBiomeSpecifier GRASS;
    static IBiomeSpecifier SGRASS;
    static IBiomeSpecifier SAVANNA;
    static IBiomeSpecifier TAIGA;
    static IBiomeSpecifier PARK;
    static IBiomeSpecifier FOREST;
    static IBiomeSpecifier SFOREST;
    static IBiomeSpecifier TFOREST;
    static IBiomeSpecifier JUNGLE;
    static IBiomeSpecifier DESERT;
    static IBiomeSpecifier SCRUB;
    static IBiomeSpecifier ALPINE;
    static IBiomeSpecifier FORESTb;
    static IBiomeSpecifier GRASSb;
    static IBiomeSpecifier PARKb;
    static IBiomeSpecifier RIVER;
    GetBeach BEACH;

    private BiomeClimateTable(IBiomeSpecifier ... table) {
        this.table = table;
    }

    private BiomeClimateTable(ClimaticWorldSettings settings) {
        this.init(settings);
    }

    public static BiomeClimateTable getClimateTable(ClimaticWorldSettings settings) {
        main = new BiomeClimateTable(settings);
        return main;
    }

    public static LandBiomeTable getLandTable() {
        if (land == null) {
            land = new LandBiomeTable();
        }
        return land;
    }

    @Override
    public long getBiome(ChunkTile tile) {
        if (tile.isRiver()) {
            return RIVER.getBiome(tile);
        }
        if (tile.getRlBiome() == 0) {
            return OCEAN.getBiome(tile);
        }
        if (tile.getTemp() > 7 && (double)(tile.getWet() - tile.getVal()) - tile.getHeight() > 0.0) {
            if ((tile.getBiomeSeed() & 1) == 1) {
                tile.nextBiomeSeed();
                return SWAMP.getBiome(tile);
            }
            tile.nextBiomeSeed();
        }
        if (tile.nextBiomeSeed().isMountain()) {
            return ALPINE.getBiome(tile);
        }
        long out = this.table[tile.getTemp() * 10 + tile.getWet()].getBiome(tile);
        Biome outb = Biome.func_150568_d((int)((int)out));
        if (outb == null) {
            Logger.getLogger("minecraft").log(Level.SEVERE, "[CLIMATIC_BIOMES] Error! Could not find biome with id " + out + "; returning 0 (Ocean).  (Check your configs.)");
            return 0L;
        }
        if (tile.isBeach()) {
            if (BiomeDictionary.hasType((Biome)outb, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)outb, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || tile.isMountain()) {
                return out;
            }
            return this.BEACH.getBiome(tile);
        }
        return out;
    }

    @Override
    public boolean isEmpty() {
        return this.table == null || this.table.length < 250;
    }

    public void init(ClimaticWorldSettings settings) {
        land = BiomeClimateTable.getLandTable();
        OCEAN = GetOcean.getOcean(settings);
        SWAMP = GetSwamp.getSwamp();
        TUNDRA = GetTundra.getTundra();
        CGRASS = GetColdPlains.getPlains();
        GRASS = GetPlains.getPlains();
        SGRASS = GetWarmPlains.getPlains();
        SAVANNA = GetSavanna.getSavanna();
        TAIGA = GetTaiga.getTaiga();
        PARK = GetPark.getPark();
        FOREST = GetForest.getForest();
        SFOREST = GetWarmForest.getForest();
        TFOREST = GetHotForest.getForest();
        JUNGLE = GetJungle.getJungle();
        DESERT = GetDesert.getDesert();
        SCRUB = GetChaparral.getChaparral();
        ALPINE = GetAlpine.getAlpine();
        FORESTb = GetCoolForest.getForest();
        GRASSb = GetCoolPlains.getPlains();
        PARKb = GetCoolPark.getPark();
        RIVER = GetRiver.getRiver();
        this.BEACH = GetBeach.getBeach();
        if (ConfigHandler.useBoP || ConfigHandler.useBoPTable) {
            this.makeModdedTable();
        } else {
            this.makeVanillaTable();
        }
        land.init(this.table);
    }

    public void makeVanillaTable() {
        this.table = new IBiomeSpecifier[]{TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TUNDRA, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, GRASS, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, SCRUB, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, SCRUB, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, SCRUB, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, SCRUB, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, SFOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, JUNGLE, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, JUNGLE, JUNGLE, JUNGLE, DESERT, DESERT, SAVANNA, SAVANNA, TFOREST, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, TFOREST, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, TFOREST, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE};
    }

    public void makeModdedTable() {
        this.table = new IBiomeSpecifier[]{TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TUNDRA, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASS, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASS, GRASS, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASS, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, SCRUB, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, SCRUB, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, SCRUB, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, SFOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, JUNGLE, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, JUNGLE, JUNGLE, JUNGLE, DESERT, DESERT, SAVANNA, SAVANNA, TFOREST, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE};
    }

    public void makeEquatorTable() {
        this.table = new IBiomeSpecifier[]{TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASS, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, SCRUB, SCRUB, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, SCRUB, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, SFOREST, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, SAVANNA, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, SAVANNA, SAVANNA, SAVANNA, TFOREST, JUNGLE, JUNGLE, JUNGLE, JUNGLE, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, JUNGLE, DESERT, DESERT, DESERT, SCRUB, SGRASS, SFOREST, SFOREST, SFOREST, SFOREST, SFOREST, DESERT, DESERT, SCRUB, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, SCRUB, SCRUB, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, GRASS, GRASS, GRASS, GRASS, PARK, FOREST, FOREST, FOREST, FOREST, FOREST, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, GRASSb, GRASSb, GRASSb, GRASSb, PARKb, FORESTb, FORESTb, FORESTb, FORESTb, FORESTb, CGRASS, CGRASS, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TUNDRA, TUNDRA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TAIGA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA};
    }

    public static class LandBiomeTable
    implements IBiomeSpecifier {
        private IBiomeSpecifier[] table;

        LandBiomeTable() {
        }

        void init(IBiomeSpecifier[] t) {
            this.table = t;
        }

        @Override
        public long getBiome(ChunkTile tile) {
            return this.table[tile.getTemp() * 10 + tile.getWet()].getBiome(tile);
        }

        @Override
        public boolean isEmpty() {
            return this.table == null;
        }

        public IBiomeSpecifier getBiomeType(ChunkTile tile) {
            return this.table[tile.getTemp() * 10 + tile.getWet()];
        }

        public boolean isDesertTile(ChunkTile tile) {
            return this.table[tile.getTemp() * 10 + tile.getWet()] == DESERT;
        }
    }
}

