/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation;

import jaredbgreat.climaticbiome.generation.map.IMapRegistry;
import jaredbgreat.climaticbiome.generation.map.MapRegistry;
import jaredbgreat.climaticbiome.generation.map.NewMapRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.Loader;

public class ClimaticBiomeProvider
extends BiomeProvider {
    private World world;
    private IMapRegistry finder;
    private boolean vanillaCacheValid = true;
    private boolean altChunks;

    public ClimaticBiomeProvider(World world, boolean altChunks) {
        this.world = world;
        this.finder = Loader.isModLoaded((String)"jeid") ? new NewMapRegistry(world.func_72905_C(), world, altChunks) : new MapRegistry(world.func_72905_C(), world, altChunks);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] barr = new Biome[i1 * j1];
        barr = this.func_76933_b(barr, i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = barr[l1];
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                biomes[j * width + i] = this.findBiomeAt((x + i) * 4, (z + j) * 4);
            }
        }
        return biomes;
    }

    public float[][] getdataForGeneration(float[][] biomes, int x, int z, int width, int height) {
        if (biomes == null || ((float[][])biomes).length < width * height) {
            biomes = new float[width * height][];
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                biomes[j * width + i] = this.finder.getHeightData((x + i) * 4, (z + j) * 4);
            }
        }
        return biomes;
    }

    private Biome findBiomeAt(int x, int z) {
        Biome[] chunk = new Biome[256];
        this.finder.getChunkBiomeGen(x / 16, z / 16, chunk);
        return chunk[this.chunkModulus(z) * 16 + this.chunkModulus(x)];
    }

    public Biome[] func_76931_a(@Nullable Biome[] in, int x, int z, int width, int depth, boolean cacheFlag) {
        if (in == null || in.length < width * depth) {
            in = new Biome[width * depth];
        }
        if (in.length == 256) {
            this.finder.getChunkBiomeGrid(x / 16, z / 16, in);
        } else {
            this.finder.getUnalignedBiomeGrid(x, z, width, depth, in);
        }
        return in;
    }

    private int getIDForCoords(int x, int z) {
        return Biome.func_185362_a((Biome)this.func_180631_a(new BlockPos(x * 4, 64, z * 4)));
    }

    private int modRight4(int in) {
        return in & 3;
    }

    private int chunkModulus(int in) {
        return in & 0xF;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        x = (x - 8) / 16;
        z = (z - 8) / 16;
        if (radius > 0) {
            int cr = radius >> 2;
            int i1 = x - cr;
            int j1 = x - cr;
            int i2 = x + cr;
            int j2 = x + cr;
            for (int i = i1 + 1; i < i2; ++i) {
                for (int j = j1; j < j2; ++j) {
                    if (allowed.contains(this.finder.getBiomeChunk(x + i, z + j))) continue;
                    return false;
                }
            }
        }
        return allowed.contains(this.finder.getBiomeChunk(x, z));
    }

    public float[] getTerrainBiomeGen(int x, int z) {
        return this.finder.getTerrainBiomeGen(x, z, new float[512]);
    }

    public void func_76938_b() {
        if (this.vanillaCacheValid) {
            try {
                super.func_76938_b();
            }
            catch (Exception e) {
                this.vanillaCacheValid = false;
                System.err.println("Error cleaning up vanilla biome cache; should I be trying to do that?!");
            }
        }
        this.finder.cleanCaches();
    }

    public boolean isAltChunks() {
        return this.altChunks;
    }
}

