/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jaredbgreat.climaticbiome.biomes.basic.Scrub;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetIslands;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.gui.GuiCBToggleButton;
import jaredbgreat.climaticbiome.gui.GuiIntSlider;
import jaredbgreat.climaticbiome.gui.GuiScaleSlider;
import jaredbgreat.climaticbiome.gui.GuiWorldTypeButton;
import net.minecraft.util.JsonUtils;

public class ClimaticWorldSettings {
    public static final String DATA_NAME = "climaticbiomesjbgGenSettings";
    private static volatile ClimaticWorldSettings queued;
    public boolean addIslands;
    public boolean extraBeaches;
    public boolean forceWhole;
    public boolean rockyScrub;
    public boolean deepSand;
    public boolean volcanicIslands;
    public boolean hasRivers;
    public boolean bigMountains;
    public int biomeSize;
    public SizeScale regionSize;
    public int mode;
    public double sisize;

    private ClimaticWorldSettings() {
        this.setDataFromConfig();
    }

    private final void setDataFromConfig() {
        this.addIslands = ConfigHandler.addIslands;
        this.extraBeaches = ConfigHandler.extraBeaches;
        this.rockyScrub = ConfigHandler.rockyScrub;
        this.deepSand = ConfigHandler.deepSand;
        this.volcanicIslands = ConfigHandler.volcanicIslands;
        this.hasRivers = ConfigHandler.hasRivers;
        this.forceWhole = ConfigHandler.forceWhole;
        this.biomeSize = ConfigHandler.biomeSize;
        this.regionSize = ConfigHandler.regionSize;
        this.mode = ConfigHandler.mode;
        this.sisize = ConfigHandler.sisize;
        this.bigMountains = ConfigHandler.bigMountains;
    }

    public final void resetFromConfig() {
        this.setDataFromConfig();
    }

    public ClimaticWorldSettings fromJson(JsonElement json) {
        JsonObject jsonObj = json.getAsJsonObject();
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"addIslands")) {
            this.addIslands = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"addIslands");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"addBeaches")) {
            this.extraBeaches = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"extraBeaches");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"rockyScrub")) {
            this.rockyScrub = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"rockyScrub");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"deepSand")) {
            this.deepSand = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"deepSand");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"volcanicIslands")) {
            this.volcanicIslands = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"volcanicIslands");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"hasRivers")) {
            this.hasRivers = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"hasRivers");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"forceWholeBiome")) {
            this.forceWhole = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"forceWholeBiome");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"biomeSize")) {
            this.biomeSize = JsonUtils.func_151203_m((JsonObject)jsonObj, (String)"biomeSize");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"regionSize")) {
            this.regionSize = SizeScale.get(JsonUtils.func_151203_m((JsonObject)jsonObj, (String)"regionSize"));
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"mapType")) {
            this.mode = JsonUtils.func_151203_m((JsonObject)jsonObj, (String)"mapType");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"SurvivalIslandSize")) {
            this.sisize = JsonUtils.func_151217_k((JsonObject)jsonObj, (String)"SurvivalIslandSize");
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonObj, (String)"BigMountains")) {
            this.bigMountains = JsonUtils.func_151212_i((JsonObject)jsonObj, (String)"BigMountains");
        }
        return this;
    }

    public ClimaticWorldSettings fromJsonString(String json) {
        JsonParser parser = new JsonParser();
        return this.fromJson(parser.parse(json));
    }

    public JsonElement toJson() {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("addIslands", Boolean.valueOf(this.addIslands));
        jsonObj.addProperty("extraBeaches", Boolean.valueOf(this.extraBeaches));
        jsonObj.addProperty("rockyScrub", Boolean.valueOf(this.rockyScrub));
        jsonObj.addProperty("deepSand", Boolean.valueOf(this.deepSand));
        jsonObj.addProperty("volcanicIslands", Boolean.valueOf(this.volcanicIslands));
        jsonObj.addProperty("hasRivers", Boolean.valueOf(this.hasRivers));
        jsonObj.addProperty("forceWholeBiome", Boolean.valueOf(this.forceWhole));
        jsonObj.addProperty("biomeSize", (Number)this.biomeSize);
        jsonObj.addProperty("regionSize", (Number)(this.regionSize.ordinal() + 1));
        jsonObj.addProperty("mapType", (Number)this.mode);
        jsonObj.addProperty("SurvivalIslandSize", (Number)this.sisize);
        jsonObj.addProperty("BigMountains", Boolean.valueOf(this.bigMountains));
        return jsonObj;
    }

    public String toJsonString() {
        return this.toJson().toString();
    }

    public String toString() {
        return super.toString() + " " + this.toJsonString();
    }

    public void applySettings() {
        Scrub.setDeepSand(this.deepSand);
        Scrub.setMakeRocks(this.rockyScrub);
        GetIslands.setVolcanicIslands(this.volcanicIslands);
    }

    public static ClimaticWorldSettings getNew() {
        if (queued == null) {
            queued = new ClimaticWorldSettings();
        }
        return queued;
    }

    public static ClimaticWorldSettings getQueued() {
        if (queued == null) {
            return new ClimaticWorldSettings();
        }
        ClimaticWorldSettings out = queued;
        queued = null;
        return out;
    }

    public static ClimaticWorldSettings getQueued(boolean delete) {
        if (queued == null) {
            return new ClimaticWorldSettings();
        }
        ClimaticWorldSettings out = queued;
        if (delete) {
            queued = null;
        }
        return out;
    }

    public static class ModeSetter
    implements ISetter<GuiWorldTypeButton> {
        ClimaticWorldSettings target;

        public ModeSetter(ClimaticWorldSettings target) {
            this.target = target;
        }

        @Override
        public void set(GuiWorldTypeButton input) {
            this.target.mode = input.getState() + 1;
        }

        @Override
        public void set(int input) {
            this.target.mode = input + 1;
        }

        @Override
        public void setTarget(ClimaticWorldSettings target) {
            this.target = target;
        }
    }

    public static class HasBigMountains
    extends BooleanSetter {
        public HasBigMountains(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.bigMountains = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.bigMountains = input != 0;
        }
    }

    public static class HasRiversSetter
    extends BooleanSetter {
        public HasRiversSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.hasRivers = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.hasRivers = input != 0;
        }
    }

    public static class VolcanicIslandsSetter
    extends BooleanSetter {
        public VolcanicIslandsSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.volcanicIslands = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.volcanicIslands = input != 0;
        }
    }

    public static class DeepSandSetter
    extends BooleanSetter {
        public DeepSandSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.deepSand = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.deepSand = input != 0;
        }
    }

    public static class RockyScrubSetter
    extends BooleanSetter {
        public RockyScrubSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.rockyScrub = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.rockyScrub = input != 0;
        }
    }

    public static class ForceWholeSetter
    extends BooleanSetter {
        public ForceWholeSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.forceWhole = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.forceWhole = input != 0;
        }
    }

    public static class ExtraBeachSetter
    extends BooleanSetter {
        public ExtraBeachSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.extraBeaches = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.extraBeaches = input != 0;
        }
    }

    public static class AddIslandsSetter
    extends BooleanSetter {
        public AddIslandsSetter(ClimaticWorldSettings target) {
            super(target);
        }

        @Override
        public void set(GuiCBToggleButton input) {
            this.target.addIslands = input.getState();
        }

        @Override
        public void set(int input) {
            this.target.addIslands = input != 0;
        }
    }

    public static class MapScaleSetter
    implements ISetter<GuiScaleSlider> {
        ClimaticWorldSettings target;

        public MapScaleSetter(ClimaticWorldSettings target) {
            this.target = target;
        }

        @Override
        public void set(GuiScaleSlider input) {
            this.target.regionSize = SizeScale.get((int)input.func_175220_c() + 1);
        }

        @Override
        public void set(int input) {
            this.target.regionSize = SizeScale.get(input);
        }

        @Override
        public void setTarget(ClimaticWorldSettings target) {
            this.target = target;
        }
    }

    public static class SISizeSetter
    implements ISetter<GuiIntSlider> {
        ClimaticWorldSettings target;

        public SISizeSetter(ClimaticWorldSettings target) {
            this.target = target;
        }

        @Override
        public void set(GuiIntSlider input) {
            this.target.sisize = input.getSliderIntValue();
        }

        @Override
        public void set(int input) {
            this.target.sisize = input;
        }

        @Override
        public void setTarget(ClimaticWorldSettings target) {
            this.target = target;
        }
    }

    public static class BiomeSizeSetter
    implements ISetter<GuiIntSlider> {
        ClimaticWorldSettings target;

        public BiomeSizeSetter(ClimaticWorldSettings target) {
            this.target = target;
        }

        @Override
        public void set(GuiIntSlider input) {
            this.target.biomeSize = input.getSliderIntValue();
        }

        @Override
        public void set(int input) {
            this.target.biomeSize = input;
        }

        @Override
        public void setTarget(ClimaticWorldSettings target) {
            this.target = target;
        }
    }

    public static abstract class BooleanSetter
    implements ISetter<GuiCBToggleButton> {
        ClimaticWorldSettings target;

        public BooleanSetter(ClimaticWorldSettings target) {
            this.target = target;
        }

        @Override
        public void setTarget(ClimaticWorldSettings target) {
            this.target = target;
        }
    }

    public static interface ISetter<T> {
        public void set(T var1);

        public void set(int var1);

        public void setTarget(ClimaticWorldSettings var1);
    }
}

