/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes.feature;

import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class GenPine
extends WorldGenAbstractTree {
    private static IBlockState TRUNK;
    private static IBlockState LEAF;

    public static void init() {
        if (ConfigHandler.pineBlocks) {
            TRUNK = BlockRegistrar.blockPineLog.func_176223_P();
            LEAF = BlockRegistrar.blockPineNeedles.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        } else {
            TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
            LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        }
    }

    public GenPine() {
        super(false);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        IBlockState state;
        BlockPos place;
        int k2;
        int i2;
        int j4;
        if (world.field_72995_K) {
            return false;
        }
        int j1 = 4 + rand.nextInt(3) + rand.nextInt(2);
        int j2 = Math.min(j1 - 1, 2 + rand.nextInt(1 + j1 / 2));
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + j1 + 3 > 255) {
            return false;
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        IBlockState under = world.func_180495_p(pos.func_177977_b());
        if (!under.func_177230_c().canSustainPlant(under, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j3 = pos.func_177956_o(); j3 < pos.func_177956_o() + j1 + 1; ++j3) {
            if (this.isReplaceable(world, (BlockPos)mutable.func_181079_c(x, j3, z))) continue;
            return false;
        }
        int w = 1;
        int bonus = rand.nextInt(2);
        int j1b = pos.func_177956_o() + j1 + 1;
        for (j4 = pos.func_177956_o() + j2; j4 < j1b; ++j4) {
            w = 1 + (j4 + bonus) % 2;
            for (i2 = x - w; i2 <= x + w; ++i2) {
                for (k2 = z - w; k2 <= z + w; ++k2) {
                    place = new BlockPos(i2, j4, k2);
                    state = world.func_180495_p(place);
                    if (!state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, place)) continue;
                    this.func_175903_a(world, place, LEAF);
                }
            }
        }
        j4 = j1b;
        for (w = 1 + (j1b + bonus) % 2; w > -1; --w) {
            for (i2 = x - w; i2 <= x + w; ++i2) {
                for (k2 = z - w; k2 <= z + w; ++k2) {
                    place = new BlockPos(i2, j4, k2);
                    state = world.func_180495_p(place);
                    if (!state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, place)) continue;
                    this.func_175903_a(world, place, LEAF);
                }
            }
            ++j4;
        }
        for (j4 = pos.func_177956_o(); j4 < j1b; ++j4) {
            BlockPos place2 = new BlockPos(x, j4, z);
            IBlockState state2 = world.func_180495_p(place2);
            this.func_175903_a(world, place2, TRUNK);
        }
        return true;
    }
}

