/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes.basic;

import jaredbgreat.climaticbiome.biomes.basic.Pinewoods;
import jaredbgreat.climaticbiome.biomes.feature.ScrubBushFinder;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;

public class Wetland
extends BiomeSwamp {
    private int wcolor;
    private static IBlockState PEAT;
    private static final IBlockState GRASS;
    protected static final WorldGenBirchTree BIRCH_TREE;
    protected final Pinewoods.IPineFinder SPRUCE;
    public final Type type;

    public Wetland(Type type, Biome.BiomeProperties properties) {
        super(properties);
        this.type = type;
        this.SPRUCE = new Pinewoods.SpruceFinder();
        this.field_76760_I.field_76832_z = type.numTrees;
        this.field_76760_I.field_76803_B = type.numGrass;
        PEAT = ConfigHandler.peatBlocks ? BlockRegistrar.blockPeat.func_176223_P() : Blocks.field_150346_d.func_176223_P();
        this.wcolor = ConfigHandler.biomeWater ? type.wcolor : 0xFFFFFF;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySlime.class, 1, 1, 1));
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        switch (this.type) {
            case BOG: {
                return this.getBogTree(rand);
            }
            case CARR: {
                return this.getCarrTree(rand);
            }
            case MARSH: {
                return this.getMarshTree(rand);
            }
        }
        return field_76757_N;
    }

    private WorldGenAbstractTree getCarrTree(Random rand) {
        if (rand.nextBoolean()) {
            return this.SPRUCE.getTree(rand);
        }
        return BIRCH_TREE;
    }

    private WorldGenAbstractTree getMarshTree(Random rand) {
        if (rand.nextBoolean()) {
            return field_76763_Q;
        }
        return field_76757_N;
    }

    private WorldGenAbstractTree getBogTree(Random rand) {
        return ScrubBushFinder.finder.getBush(rand);
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        switch (this.type) {
            case BOG: {
                this.decorateBog(world, rand, pos);
                break;
            }
            case CARR: {
                this.decorateCarr(world, rand, pos);
                break;
            }
            case MARSH: {
                this.decorateMarsh(world, rand, pos);
                break;
            }
        }
    }

    private void decorateBog(World world, Random rand, BlockPos pos) {
        int z;
        int x;
        int i;
        if (rand.nextInt(5) == 0) {
            for (int i2 = rand.nextInt(32) + rand.nextInt(32) + 32; i2 > 0; --i2) {
                int z2;
                int y;
                int x2 = rand.nextInt(16) + 8;
                BlockPos tpos = pos.func_177982_a(x2, y = world.func_175645_m(pos.func_177982_a(x2, 0, z2 = rand.nextInt(16) + 8)).func_177956_o() - 1, z2);
                if (world.func_180495_p(tpos).func_185904_a() != Material.field_151577_b) continue;
                world.func_175656_a(tpos, PEAT);
            }
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        int n = rand.nextInt(5) + 4;
        for (i = 0; i < n; ++i) {
            x = rand.nextInt(16) + 8;
            z = rand.nextInt(16) + 8;
            int y = rand.nextBoolean() ? rand.nextInt(world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() + 32) : world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o();
            field_180280_ag.func_180709_b(world, rand, pos.func_177982_a(x, y, z));
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
        n = rand.nextInt(5) - 3;
        for (i = 0; i < n; ++i) {
            x = rand.nextInt(16) + 8;
            z = rand.nextInt(16) + 8;
            int y = rand.nextBoolean() ? rand.nextInt(world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() + 32) : world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o();
            field_180280_ag.func_180709_b(world, rand, pos.func_177982_a(x, y, z));
        }
    }

    private void decorateCarr(World world, Random rand, BlockPos pos) {
        int y;
        int z;
        int x;
        int i;
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        int n = rand.nextInt(4) - 1;
        for (i = 0; i < n; ++i) {
            x = rand.nextInt(16) + 8;
            z = rand.nextInt(16) + 8;
            y = rand.nextBoolean() ? rand.nextInt(world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() + 32) : world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o();
            field_180280_ag.func_180709_b(world, rand, pos.func_177982_a(x, y, z));
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
        n = rand.nextInt(4) - 2;
        for (i = 0; i < n; ++i) {
            x = rand.nextInt(16) + 8;
            z = rand.nextInt(16) + 8;
            y = rand.nextBoolean() ? rand.nextInt(world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() + 32) : world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o();
            field_180280_ag.func_180709_b(world, rand, pos.func_177982_a(x, y, z));
        }
    }

    private void decorateMarsh(World world, Random rand, BlockPos pos) {
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
        int n = rand.nextInt(5) + 8;
        for (int i = 0; i < n; ++i) {
            int x = rand.nextInt(16) + 8;
            int z = rand.nextInt(16) + 8;
            int y = rand.nextBoolean() ? rand.nextInt(world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() + 32) : world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o();
            field_180280_ag.func_180709_b(world, rand, pos.func_177982_a(x, y, z));
        }
    }

    public int func_180627_b(BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return this.getModdedBiomeGrassColor(d0 < -0.1 ? this.type.grassA : this.type.grassB);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(this.type.leaves);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer chunkPrimer, int x, int z, double noise) {
        if (this.type == Type.BOG && (noise > 1.75 || noise < -1.75)) {
            this.field_76753_B = PEAT;
        }
        super.func_180622_a(world, rand, chunkPrimer, x, z, noise);
    }

    public boolean func_76736_e() {
        return true;
    }

    public int getWaterColorMultiplier() {
        return this.wcolor;
    }

    static {
        GRASS = Blocks.field_150349_c.func_176223_P();
        BIRCH_TREE = new WorldGenBirchTree(false, false);
    }

    public static enum Type {
        MARSH(0, 12, 2472764, 3708988, 6975545, 0xFFFFFF),
        BOG(3, 10, 5011004, 6975545, 5015100, 6117145),
        CARR(8, 5, 5011004, 6975545, 6979641, 9670482);

        public final int numTrees;
        public final int numGrass;
        public final int grassA;
        public final int grassB;
        public final int leaves;
        public final int wcolor;

        private Type(int numTrees, int numGrass, int a, int b, int l, int w) {
            this.numTrees = numTrees;
            this.numGrass = numGrass;
            this.grassA = a;
            this.grassB = b;
            this.leaves = l;
            this.wcolor = w;
        }
    }
}

