/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes.basic;

import jaredbgreat.climaticbiome.biomes.feature.ScrubBushFinder;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;

public class Scrub
extends Biome {
    private static final WorldGenBlockBlob ROCK_PILES = new WorldGenBlockBlob(Blocks.field_150347_e, 0);
    private static boolean deepSand = true;
    private static boolean makeRocks = true;
    private final Type type;

    public Scrub(Type type, Biome.BiomeProperties properties) {
        super(properties);
        this.type = type;
        this.field_76760_I.field_76804_C = 5;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        if (type == Type.DRY) {
            this.setupDry();
        } else {
            this.setupDense();
        }
    }

    private void setupDense() {
        this.field_76760_I.field_76832_z = 3;
        this.field_76760_I.field_76803_B = 6;
    }

    private void setupDry() {
        this.field_76760_I.field_76800_F = 15;
        this.field_76760_I.field_76832_z = 1;
        this.field_76760_I.field_76803_B = 2;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (this.type != Type.DRY && !ConfigHandler.useDT && random.nextInt(5) == 0) {
            return field_76757_N;
        }
        return ScrubBushFinder.finder.getBush(random);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noise) {
        this.field_76753_B = deepSand && this.type == Type.DRY && noise > 1.25 ? this.type.altTop : Blocks.field_150346_d.func_176223_P();
        this.field_76752_A = noise > 1.25 ? this.type.altTop : Blocks.field_150349_c.func_176223_P();
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noise);
    }

    public void func_180624_a(World worldIn, Random random, BlockPos pos) {
        if (makeRocks) {
            int n = this.type == Type.DRY ? random.nextInt(4) : random.nextInt(2);
            for (int i = 0; i < n; ++i) {
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(random.nextInt(16) + 8, 0, random.nextInt(16) + 8));
                ROCK_PILES.func_180709_b(worldIn, random, blockpos);
            }
        }
        super.func_180624_a(worldIn, random, pos);
    }

    public static void setDeepSand(boolean in) {
        deepSand = in;
    }

    public static void setMakeRocks(boolean in) {
        makeRocks = in;
    }

    public static enum Type {
        DENSE(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT)),
        DRY(Blocks.field_150354_m.func_176223_P());

        public final IBlockState altTop;

        private Type(IBlockState block) {
            this.altTop = block;
        }
    }
}

