/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes.basic;

import jaredbgreat.climaticbiome.biomes.basic.Pinewoods;
import jaredbgreat.climaticbiome.biomes.decorators.MediterranianAlpineDecorator;
import jaredbgreat.climaticbiome.biomes.feature.GenNoTree;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class MontaneForest
extends Biome {
    private static final WorldGenSavannaTree SAVANNA_TREE = new WorldGenSavannaTree(false);
    private static final GenNoTree NOTHING = new GenNoTree();
    protected static final WorldGenBirchTree BIRCH = new WorldGenBirchTree(false, false);
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final Pinewoods.IPineFinder PINE;
    private final Pinewoods.IPineFinder SPRUCE;
    public Type type;

    public MontaneForest(Type type, Biome.BiomeProperties properties) {
        super(properties);
        this.type = type;
        if (type == Type.MEDITERRANIAN) {
            this.field_76760_I = new MediterranianAlpineDecorator();
        }
        this.PINE = ConfigHandler.addPines ? new Pinewoods.PineFinder() : new Pinewoods.SpruceFinder();
        this.SPRUCE = new Pinewoods.SpruceFinder();
        if (type == Type.HOT) {
            this.field_76760_I.field_76832_z = 20;
        } else if (type == Type.MEDITERRANIAN) {
            this.field_76760_I.field_76832_z = -999;
        } else {
            this.field_76760_I.field_76832_z = 7;
            this.field_76760_I.field_76803_B = 2;
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        switch (this.type) {
            case COOL: {
                return this.getCoolTrees(rand);
            }
            case HOT: {
                return this.getHotTrees(rand);
            }
            case MEDITERRANIAN: {
                return this.getMediterranianTrees(rand);
            }
            case WARM: {
                return this.getWarmTrees(rand);
            }
        }
        return this.getWarmTrees(rand);
    }

    private WorldGenAbstractTree getWarmTrees(Random rand) {
        int kind = rand.nextInt(5);
        switch (kind) {
            case 0: {
                return field_76758_O;
            }
            case 1: {
                return this.PINE.getTree(rand);
            }
            case 2: {
                return BIRCH;
            }
            case 3: {
                return this.SPRUCE.getTree(rand);
            }
        }
        return field_76757_N;
    }

    private WorldGenAbstractTree getCoolTrees(Random rand) {
        int kind = rand.nextInt(6);
        switch (kind) {
            case 0: {
                return field_76758_O;
            }
            case 1: {
                return this.SPRUCE.getTree(rand);
            }
            case 2: {
                return BIRCH;
            }
            case 3: {
                return this.SPRUCE.getTree(rand);
            }
            case 4: {
                return this.SPRUCE.getTree(rand);
            }
        }
        return BIRCH;
    }

    private WorldGenAbstractTree getHotTrees(Random rand) {
        int kind = rand.nextInt(10);
        switch (kind) {
            case 0: {
                return field_76758_O;
            }
            case 1: {
                return this.PINE.getTree(rand);
            }
            case 2: {
                return new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case 3: {
                return new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case 4: {
                return new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case 5: {
                return SAVANNA_TREE;
            }
        }
        return new WorldGenShrub(JUNGLE_LOG, OAK_LEAF);
    }

    public WorldGenAbstractTree getMediterranianTrees(Random rand) {
        int kind = rand.nextInt(6);
        switch (kind) {
            case 0: {
                return field_76758_O;
            }
            case 1: {
                return this.PINE.getTree(rand);
            }
            case 2: {
                return this.PINE.getTree(rand);
            }
            case 3: {
                return this.PINE.getTree(rand);
            }
            case 4: {
                return BIRCH;
            }
        }
        return field_76757_N;
    }

    public static enum Type {
        COOL,
        WARM,
        HOT,
        MEDITERRANIAN;

    }
}

