/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes.basic;

import jaredbgreat.climaticbiome.biomes.decorators.VolcanoDecorator;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import java.util.Random;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ActiveVolcano
extends Biome {
    protected static IBlockState BASALT;
    protected static IBlockState ASH;
    protected static WorldGenLakes LAVA;

    public ActiveVolcano(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I = new VolcanoDecorator();
        this.field_76760_I.field_76800_F = -999;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76762_K.clear();
        this.field_76755_L.clear();
    }

    public static void init() {
        String a = ConfigHandler.ashBlock;
        String b = ConfigHandler.basaltBlock;
        if (a == null || a.equals("default") || a.equals("climaticbiomesjbg:volcanic_ash")) {
            ASH = BlockRegistrar.getAshBlock();
        } else {
            ASH = ActiveVolcano.getBlockState(a);
            if (ASH == null) {
                ASH = BlockRegistrar.getAshBlock();
            }
        }
        if (b == null || b.equals("default") || b.equals("climaticbiomesjbg:basalt")) {
            BASALT = BlockRegistrar.getBasaltBlock();
        } else {
            BASALT = ActiveVolcano.getBlockState(b);
            if (BASALT == null) {
                BASALT = BlockRegistrar.getBasaltBlock();
            }
        }
    }

    private static IBlockState getBlockState(String s) {
        StringTokenizer tokens = new StringTokenizer(s, "()");
        String str = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            int meta = Integer.parseInt(tokens.nextToken());
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(str))).func_176203_a(meta);
        }
        return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(str))).func_176223_P();
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer cpi, int x, int z, double noise) {
        this.field_76753_B = noise > 2.5 ? ASH : BASALT;
        this.field_76752_A = noise > 1.25 ? ASH : (rand.nextInt(196) == 0 ? Blocks.field_150343_Z.func_176223_P() : BASALT);
        this.func_180628_b(worldIn, rand, cpi, x, z, noise);
        int k1 = x & 0xF;
        int l1 = z & 0xF;
        int ty = 64 + (int)(noise * 4.0);
        for (int j1 = 255; j1 >= ty; --j1) {
            if (cpi.func_177856_a(l1, j1, k1).func_177230_c() != Blocks.field_150348_b) continue;
            cpi.func_177855_a(l1, j1, k1, BASALT);
        }
    }

    static {
        LAVA = new WorldGenLakes((Block)Blocks.field_150353_l);
    }
}

