/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome;

import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.biomes.basic.ActiveVolcano;
import jaredbgreat.climaticbiome.biomes.feature.GenPine;
import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.compat.userdef.VariantParser;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.ClimaticRealisticWorldType;
import jaredbgreat.climaticbiome.generation.ClimaticWorldType;
import jaredbgreat.climaticbiome.generation.mutators.SpecialGenHandler;
import jaredbgreat.climaticbiome.proxy.IProxy;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import jaredbgreat.climaticbiome.util.Externalizer;
import jaredbgreat.climaticbiome.util.ItemRegistrar;
import java.io.File;
import java.util.logging.Logger;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod(modid="climaticbiomesjbg", name="Climatic Biomes", version="2.16.3", acceptableRemoteVersions="2.16.3", dependencies="after:biomesoplenty; after:dynamictrees; after:jeid", acceptedMinecraftVersions="[1.12.2]")
public class ClimaticBiomes {
    private static SpecialGenHandler specialGen;
    @Mod.Instance
    public static ClimaticBiomes instance;
    public static ClimaticWorldType climaticWorldType;
    public static ClimaticRealisticWorldType realisticWorldType;
    public ConfigHandler configHandler;
    File confdir;
    @SidedProxy(clientSide="jaredbgreat.climaticbiome.proxy.ClientProxy", serverSide="jaredbgreat.climaticbiome.proxy.ServerProxy")
    public static IProxy proxy;
    public static org.apache.logging.log4j.Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.confdir = new File(event.getModConfigurationDirectory().toPath() + File.separator + "ClimaticBiomes");
        this.configHandler = new ConfigHandler(this.confdir.toString());
        this.configHandler.load();
        BlockRegistrar.initBlocks();
        ItemRegistrar.initItems();
        GenPine.init();
        climaticWorldType = new ClimaticWorldType();
        realisticWorldType = new ClimaticRealisticWorldType();
        ModBiomes.createBiomes();
        if (ConfigHandler.addToVanilla) {
            ModBiomes.addToVanilla();
        }
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        specialGen = new SpecialGenHandler();
        ItemRegistrar.addRecipes();
        this.makeFiles();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        block6: {
            ActiveVolcano.init();
            if (ConfigHandler.makeDefault) {
                this.moveWorldTypes();
            }
            if (ConfigHandler.writeBiomeLists) {
                DefReader.writeList(this.confdir);
            }
            if (ConfigHandler.writeWTLists) {
                DefReader.writeWTList(this.confdir);
            }
            DefReader.init(ForgeRegistries.BIOMES, this.confdir);
            VariantParser.parse(this.confdir);
            ItemRegistrar.oreDict();
            try {
                if (!ConfigHandler.moreMansion) break block6;
                for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                    if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && WoodlandMansion.field_191072_a.contains(biome)) continue;
                }
            }
            catch (UnsupportedOperationException e) {
                Logger log = Logger.getLogger("Minecraft");
                log.warning("[Climatic Biomes] Woodland Mansion genaraion cannot be modified!");
                log.warning("[Climatic Biomes] You might need a different version of Forge or Java (probably Java)");
            }
        }
    }

    private void makeFiles() {
        Externalizer extern = new Externalizer();
        extern.copyOut(this.confdir);
    }

    private void moveWorldTypes() {
        WorldType.field_77139_a[0] = climaticWorldType;
    }
}

