/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class Statistics {
    public static final double avg(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int n = 0;
        if (to >= from && delta > 0.0) {
            double i;
            for (i = from; i < to; i += delta) {
                sum += mXparser.getFunctionValue(f, index, i);
                ++n;
            }
            if (delta - (i - to) > 0.5 * delta) {
                sum += mXparser.getFunctionValue(f, index, to);
                ++n;
            }
        } else if (to <= from && delta < 0.0) {
            double i;
            for (i = from; i > to; i += delta) {
                sum += mXparser.getFunctionValue(f, index, i);
                ++n;
            }
            if (delta - (to - i) > 0.5 * delta) {
                sum += mXparser.getFunctionValue(f, index, to);
                ++n;
            }
        } else if (from == to) {
            return mXparser.getFunctionValue(f, index, from);
        }
        return sum / (double)n;
    }

    public static final double var(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        return Statistics.var(mXparser.getFunctionValues(f, index, from, to, delta));
    }

    public static final double std(Expression f, Argument index, double from, double to, double delta) {
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return Double.NaN;
        }
        return Statistics.std(mXparser.getFunctionValues(f, index, from, to, delta));
    }

    public static final double avg(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            return numbers[0];
        }
        double sum = 0.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += xi;
        }
        return sum / (double)numbers.length;
    }

    public static final double var(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            if (Double.isNaN(numbers[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        double m = Statistics.avg(numbers);
        double sum = 0.0;
        for (double xi : numbers) {
            if (Double.isNaN(xi)) {
                return Double.NaN;
            }
            sum += (xi - m) * (xi - m);
        }
        return sum / (double)(numbers.length - 1);
    }

    public static final double std(double ... numbers) {
        if (numbers.length == 0) {
            return Double.NaN;
        }
        if (numbers.length == 1) {
            if (Double.isNaN(numbers[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        return MathFunctions.sqrt(Statistics.var(numbers));
    }
}

