/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.mrcrayfish.obfuscate.common.data.IDataSerializer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Serializers {
    public static final IDataSerializer<Boolean> BOOLEAN = new IDataSerializer<Boolean>(){

        @Override
        public void write(ByteBuf buf, Boolean value) {
            buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean read(ByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public NBTBase write(Boolean value) {
            return new NBTTagByte((byte)(value != false ? 1 : 0));
        }

        @Override
        public Boolean read(NBTBase nbt) {
            return ((NBTTagByte)nbt).func_150290_f() != 0;
        }
    };
    public static final IDataSerializer<Byte> BYTE = new IDataSerializer<Byte>(){

        @Override
        public void write(ByteBuf buf, Byte value) {
            buf.writeByte((int)value.byteValue());
        }

        @Override
        public Byte read(ByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public NBTBase write(Byte value) {
            return new NBTTagByte(value.byteValue());
        }

        @Override
        public Byte read(NBTBase nbt) {
            return ((NBTTagByte)nbt).func_150290_f();
        }
    };
    public static final IDataSerializer<Short> SHORT = new IDataSerializer<Short>(){

        @Override
        public void write(ByteBuf buf, Short value) {
            buf.writeShort((int)value.shortValue());
        }

        @Override
        public Short read(ByteBuf buf) {
            return buf.readShort();
        }

        @Override
        public NBTBase write(Short value) {
            return new NBTTagShort(value.shortValue());
        }

        @Override
        public Short read(NBTBase nbt) {
            return ((NBTTagShort)nbt).func_150289_e();
        }
    };
    public static final IDataSerializer<Integer> INTEGER = new IDataSerializer<Integer>(){

        @Override
        public void write(ByteBuf buf, Integer value) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)value, (int)4);
        }

        @Override
        public Integer read(ByteBuf buf) {
            return ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        }

        @Override
        public NBTBase write(Integer value) {
            return new NBTTagInt(value.intValue());
        }

        @Override
        public Integer read(NBTBase nbt) {
            return ((NBTTagInt)nbt).func_150287_d();
        }
    };
    public static final IDataSerializer<Long> LONG = new IDataSerializer<Long>(){

        @Override
        public void write(ByteBuf buf, Long value) {
            buf.writeLong(value.longValue());
        }

        @Override
        public Long read(ByteBuf buf) {
            return buf.readLong();
        }

        @Override
        public NBTBase write(Long value) {
            return new NBTTagLong(value.longValue());
        }

        @Override
        public Long read(NBTBase nbt) {
            return ((NBTTagLong)nbt).func_150291_c();
        }
    };
    public static final IDataSerializer<Float> FLOAT = new IDataSerializer<Float>(){

        @Override
        public void write(ByteBuf buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public NBTBase write(Float value) {
            return new NBTTagFloat(value.floatValue());
        }

        @Override
        public Float read(NBTBase nbt) {
            return Float.valueOf(((NBTTagFloat)nbt).func_150288_h());
        }
    };
    public static final IDataSerializer<Double> DOUBLE = new IDataSerializer<Double>(){

        @Override
        public void write(ByteBuf buf, Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double read(ByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public NBTBase write(Double value) {
            return new NBTTagDouble(value.doubleValue());
        }

        @Override
        public Double read(NBTBase nbt) {
            return ((NBTTagDouble)nbt).func_150286_g();
        }
    };
    public static final IDataSerializer<Character> CHARACTER = new IDataSerializer<Character>(){

        @Override
        public void write(ByteBuf buf, Character value) {
            buf.writeChar((int)value.charValue());
        }

        @Override
        public Character read(ByteBuf buf) {
            return Character.valueOf(buf.readChar());
        }

        @Override
        public NBTBase write(Character value) {
            return new NBTTagInt((int)value.charValue());
        }

        @Override
        public Character read(NBTBase nbt) {
            return Character.valueOf((char)((NBTTagInt)nbt).func_150287_d());
        }
    };
    public static final IDataSerializer<String> STRING = new IDataSerializer<String>(){

        @Override
        public void write(ByteBuf buf, String value) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value);
        }

        @Override
        public String read(ByteBuf buf) {
            return ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @Override
        public NBTBase write(String value) {
            return new NBTTagString(value);
        }

        @Override
        public String read(NBTBase nbt) {
            return ((NBTTagString)nbt).func_150285_a_();
        }
    };
    public static final IDataSerializer<NBTTagCompound> TAG_COMPOUND = new IDataSerializer<NBTTagCompound>(){

        @Override
        public void write(ByteBuf buf, NBTTagCompound value) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)value);
        }

        @Override
        public NBTTagCompound read(ByteBuf buf) {
            return ByteBufUtils.readTag((ByteBuf)buf);
        }

        @Override
        public NBTBase write(NBTTagCompound value) {
            return value;
        }

        @Override
        public NBTTagCompound read(NBTBase nbt) {
            return (NBTTagCompound)nbt;
        }
    };
    public static final IDataSerializer<BlockPos> BLOCK_POS = new IDataSerializer<BlockPos>(){

        @Override
        public void write(ByteBuf buf, BlockPos value) {
            buf.writeLong(value.func_177986_g());
        }

        @Override
        public BlockPos read(ByteBuf buf) {
            return BlockPos.func_177969_a((long)buf.readLong());
        }

        @Override
        public NBTBase write(BlockPos value) {
            return new NBTTagLong(value.func_177986_g());
        }

        @Override
        public BlockPos read(NBTBase nbt) {
            return BlockPos.func_177969_a((long)((NBTTagLong)nbt).func_150291_c());
        }
    };
    public static final IDataSerializer<UUID> UUID = new IDataSerializer<UUID>(){

        @Override
        public void write(ByteBuf buf, UUID value) {
            buf.writeLong(value.getMostSignificantBits());
            buf.writeLong(value.getLeastSignificantBits());
        }

        @Override
        public UUID read(ByteBuf buf) {
            return new UUID(buf.readLong(), buf.readLong());
        }

        @Override
        public NBTBase write(UUID value) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a("Most", value.getMostSignificantBits());
            compound.func_74772_a("Least", value.getLeastSignificantBits());
            return compound;
        }

        @Override
        public UUID read(NBTBase nbt) {
            NBTTagCompound compound = new NBTTagCompound();
            return new UUID(compound.func_74763_f("Most"), compound.func_74763_f("Least"));
        }
    };
    public static final IDataSerializer<ItemStack> ITEM_STACK = new IDataSerializer<ItemStack>(){

        @Override
        public void write(ByteBuf buf, ItemStack value) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)value);
        }

        @Override
        public ItemStack read(ByteBuf buf) {
            return ByteBufUtils.readItemStack((ByteBuf)buf);
        }

        @Override
        public NBTBase write(ItemStack value) {
            return value.func_77955_b(new NBTTagCompound());
        }

        @Override
        public ItemStack read(NBTBase nbt) {
            return new ItemStack((NBTTagCompound)nbt);
        }
    };
    public static final IDataSerializer<ResourceLocation> RESOURCE_LOCATION = new IDataSerializer<ResourceLocation>(){

        @Override
        public void write(ByteBuf buf, ResourceLocation value) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.toString());
        }

        @Override
        public ResourceLocation read(ByteBuf buf) {
            return new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @Override
        public NBTBase write(ResourceLocation value) {
            return new NBTTagString(value.toString());
        }

        @Override
        public ResourceLocation read(NBTBase nbt) {
            return new ResourceLocation(((NBTTagString)nbt).func_150285_a_());
        }
    };
}

