/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenPodzol;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.blocks.BlockPineNeedles;
import jaredbgreat.climaticbiome.compat.dynamictrees.DynamicTreeHelper;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreePine
extends TreeFamily {
    public TreePine() {
        super(new ResourceLocation("climaticbiomesjbg", "pine"));
        IBlockState primLog = BlockRegistrar.blockPineLog.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack((Block)BlockRegistrar.blockPineLog));
        DynamicTreeHelper.pineLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockPineNeedles);
    }

    public void createSpecies() {
        this.setCommonSpecies(new PineSpeciesBase(this));
        this.getCommonSpecies().generateSeed();
    }

    public class PineSpeciesBase
    extends Species {
        public PineSpeciesBase(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreeHelper.pineLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 16.0f, 3, 4, 1.3f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
            this.envFactor(BiomeDictionary.Type.WASTELAND, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
            this.addGenFeature((IGenFeature)new FeatureGenPodzol());
        }

        public boolean isBiomePerfect(Biome biome) {
            return biome == ModBiomes.pineWoods || biome == ModBiomes.warmForest || biome == ModBiomes.warmForestHills || biome == ModBiomes.mediMontaneForest;
        }

        public Species generateSeed() {
            Seed seed = new Seed("climaticbiomesdt:pineseed");
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }
    }
}

