/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import jaredbgreat.climaticbiome.compat.dynamictrees.DataBasePop;
import jaredbgreat.climaticbiome.compat.dynamictrees.TreePine;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="climaticbiomesdt")
public class DynamicTreeHelper {
    public static TreePine pineTree;
    public static Species pineSpecies;
    public static TreeFamily jungle;
    public static Species smallJungle;
    public static ILeavesProperties pineLeavesProperties;
    public static ILeavesProperties jungleLeavesProperties;

    public static void preInit() {
        IForgeRegistry blockRegistry = GameRegistry.findRegistry(Block.class);
        IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
        pineLeavesProperties = new LeavesProperties(BlockRegistrar.blockPineNeedles.func_176223_P());
        LeavesPaging.getLeavesBlockForSequence((String)"climaticbiomesdt", (int)0, (ILeavesProperties)pineLeavesProperties);
        pineTree = new TreePine();
        pineTree.registerSpecies(Species.REGISTRY);
        ArrayList treeBlocks = new ArrayList();
        pineTree.getRegisterableBlocks(treeBlocks);
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"climaticbiomesdt").values());
        blockRegistry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
        ArrayList treeItems = new ArrayList();
        pineTree.getRegisterableItems(treeItems);
        itemRegistry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    public static void init() {
        pineSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("climaticbiomesjbg", "pine"));
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new DataBasePop());
    }

    public static void postInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        ModelHelper.regModel((Block)pineTree.getDynamicBranch());
        ModelHelper.regModel((Item)pineTree.getCommonSpecies().getSeed());
        ModelHelper.regModel((TreeFamily)pineTree);
        LeavesPaging.getLeavesMapForModId((String)"climaticbiomesdt").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientInit() {
        int magenta = 0xFF00FF;
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"climaticbiomesdt").values()) {
            ModelHelper.regColorHandler((Block)leaves, (IBlockColor)new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves((Block)block)) {
                        return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
        }
    }

    public static Item getPineSeed() {
        return pineTree.getCommonSpecies().getSeed();
    }
}

