/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.compat.dynamictrees.DynamicTreeHelper;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import net.minecraft.world.biome.Biome;

public class DataBasePop
implements IBiomeDataBasePopulator {
    private static Species oak;
    private static Species birch;
    private static Species spruce;
    private static Species acacia;
    private static Species jungle;
    private static Species apple;
    private static Species oakswamp;
    private static Species cactus;
    private static Species pine;

    public void populate(BiomeDataBase db) {
        oak = TreeRegistry.findSpeciesSloppy((String)"oak");
        birch = TreeRegistry.findSpeciesSloppy((String)"birch");
        spruce = TreeRegistry.findSpeciesSloppy((String)"spruce");
        acacia = TreeRegistry.findSpeciesSloppy((String)"acacia");
        jungle = TreeRegistry.findSpeciesSloppy((String)"jungle");
        apple = TreeRegistry.findSpeciesSloppy((String)"apple");
        oakswamp = TreeRegistry.findSpeciesSloppy((String)"oakswamp");
        cactus = TreeRegistry.findSpeciesSloppy((String)"cactus");
        pine = ConfigHandler.addPines ? DynamicTreeHelper.pineSpecies : spruce;
        if (ConfigHandler.includeForests) {
            this.populateForests(db);
        }
        this.populateScrub(db);
        if (ConfigHandler.includeMountains) {
            this.populateMountains(db);
        }
        if (ConfigHandler.includePlains) {
            this.populatePlains(db);
        }
        if (ConfigHandler.includeSwamps) {
            this.populateSwamps(db);
        }
    }

    private void populateScrub(BiomeDataBase db) {
        db.setSpeciesSelector((Biome)ModBiomes.denseScrub, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.denseScrub, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.denseScrub, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.denseScrub, false);
        db.setForestness((Biome)ModBiomes.denseScrub, 0.1f);
        db.setSpeciesSelector((Biome)ModBiomes.denseScrubHills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.denseScrubHills, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.denseScrubHills, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.denseScrubHills, false);
        db.setForestness((Biome)ModBiomes.denseScrubHills, 0.1f);
        db.setSpeciesSelector((Biome)ModBiomes.dryScrub, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(cactus, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.dryScrub, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.dryScrub, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.dryScrub, false);
        db.setForestness((Biome)ModBiomes.dryScrub, 0.0f);
        db.setSpeciesSelector((Biome)ModBiomes.dryScrubHills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(cactus, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.dryScrubHills, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.dryScrubHills, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.dryScrubHills, false);
        db.setForestness((Biome)ModBiomes.dryScrubHills, 0.0f);
        db.setSpeciesSelector((Biome)ModBiomes.coolPlains, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
    }

    private void populateForests(BiomeDataBase db) {
        db.setSpeciesSelector((Biome)ModBiomes.warmForest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(pine, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.warmForest, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.warmForest, true);
        db.setDensitySelector((Biome)ModBiomes.warmForest, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.warmForest, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.warmForestHills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(pine, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.warmForestHills, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.warmForestHills, true);
        db.setDensitySelector((Biome)ModBiomes.warmForestHills, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.warmForestHills, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.tropicalForest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(acacia, 4).add(oak, 2), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.tropicalForest, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.tropicalForest, true);
        db.setDensitySelector((Biome)ModBiomes.tropicalForest, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.tropicalForest, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.tropicalForestHills, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(acacia, 4).add(oak, 2), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.tropicalForestHills, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.tropicalForestHills, true);
        db.setDensitySelector((Biome)ModBiomes.tropicalForestHills, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.tropicalForestHills, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.pineWoods, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(pine, 4).add(oakswamp, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.pineWoods, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.pineWoods, true);
        db.setDensitySelector((Biome)ModBiomes.pineWoods, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.pineWoods, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
    }

    private void populateMountains(BiomeDataBase db) {
        db.setSpeciesSelector((Biome)ModBiomes.warmMountain, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 7).add(birch, 2).add(spruce, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.warmMountain, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.warmMountain, (rnd, spc, rad) -> rnd.nextInt(24) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.warmMountain, true);
        db.setForestness((Biome)ModBiomes.warmMountain, 0.01f);
        db.setSpeciesSelector((Biome)ModBiomes.warmMountainTrees, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 7).add(birch, 2).add(spruce, 1), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.warmMountainTrees, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.warmMountainTrees, (rnd, spc, rad) -> rnd.nextBoolean() ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.warmMountainTrees, true);
        db.setForestness((Biome)ModBiomes.warmMountainTrees, 0.2f);
        db.setSpeciesSelector((Biome)ModBiomes.hotMountain, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(pine, 2), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.hotMountain, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.hotMountain, (rnd, spc, rad) -> rnd.nextInt(24) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.hotMountain, true);
        db.setForestness((Biome)ModBiomes.hotMountain, 0.01f);
        db.setSpeciesSelector((Biome)ModBiomes.hotMountainTrees, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(pine, 2), BiomeDataBase.Operation.REPLACE);
        db.setDensitySelector((Biome)ModBiomes.hotMountainTrees, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.hotMountainTrees, (rnd, spc, rad) -> rnd.nextBoolean() ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.hotMountainTrees, true);
        db.setForestness((Biome)ModBiomes.hotMountainTrees, 0.2f);
        db.setSpeciesSelector((Biome)ModBiomes.coolMontaneForest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(birch, 1).add(spruce, 2), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.coolMontaneForest, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.coolMontaneForest, true);
        db.setDensitySelector((Biome)ModBiomes.coolMontaneForest, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.coolMontaneForest, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.warmMontaneForest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(birch, 1).add(spruce, 1).add(pine, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.warmMontaneForest, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.warmMontaneForest, true);
        db.setDensitySelector((Biome)ModBiomes.warmMontaneForest, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.warmMontaneForest, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.mediMontaneForest, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(birch, 1).add(pine, 3), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.mediMontaneForest, 0.75f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.mediMontaneForest, true);
        db.setDensitySelector((Biome)ModBiomes.mediMontaneForest, (rnd, nd) -> nd * 0.75, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.mediMontaneForest, (rnd, spc, rad) -> rnd.nextInt(4) == 0 ? BiomePropertySelectors.EnumChance.CANCEL : BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.montaneJungle, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(acacia, 1).add(pine, 1).add(jungle, 3), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.montaneJungle, 1.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.montaneJungle, true);
        db.setDensitySelector((Biome)ModBiomes.montaneJungle, (rnd, nd) -> nd * 1.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.montaneJungle, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        if (ConfigHandler.includeVolcano) {
            db.setSpeciesSelector((Biome)ModBiomes.activeVolcano, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
            db.setForestness((Biome)ModBiomes.activeVolcano, 0.0f);
            db.setCancelVanillaTreeGen((Biome)ModBiomes.activeVolcano, true);
            db.setDensitySelector((Biome)ModBiomes.activeVolcano, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
            db.setChanceSelector((Biome)ModBiomes.activeVolcano, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        }
    }

    private void populatePlains(BiomeDataBase db) {
        db.setForestness((Biome)ModBiomes.coolPlains, 0.1f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.coolPlains, true);
        db.setDensitySelector((Biome)ModBiomes.coolPlains, (rnd, nd) -> nd * 0.1, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.coolPlains, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.coldPlains, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(spruce, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.coldPlains, 0.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.coldPlains, true);
        db.setDensitySelector((Biome)ModBiomes.coldPlains, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.coldPlains, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.windswept, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.windswept, 0.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.windswept, true);
        db.setDensitySelector((Biome)ModBiomes.windswept, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.windswept, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.coolWindswept, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.coolWindswept, 0.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.coolWindswept, true);
        db.setDensitySelector((Biome)ModBiomes.coolWindswept, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.coolWindswept, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
    }

    private void populateSwamps(BiomeDataBase db) {
        db.setSpeciesSelector((Biome)ModBiomes.carr, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 1).add(birch, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.carr, 0.9f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.carr, true);
        db.setDensitySelector((Biome)ModBiomes.carr, (rnd, nd) -> nd, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.carr, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.marsh, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(oakswamp, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.marsh, 0.1f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.marsh, true);
        db.setDensitySelector((Biome)ModBiomes.marsh, (rnd, nd) -> nd * 0.1, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.marsh, (rnd, spc, rad) -> rnd.nextInt(10) == 0 ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
        db.setSpeciesSelector((Biome)ModBiomes.bog, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(oakswamp, 1), BiomeDataBase.Operation.REPLACE);
        db.setForestness((Biome)ModBiomes.bog, 0.0f);
        db.setCancelVanillaTreeGen((Biome)ModBiomes.bog, false);
        db.setDensitySelector((Biome)ModBiomes.bog, (rnd, nd) -> 0.0, BiomeDataBase.Operation.REPLACE);
        db.setChanceSelector((Biome)ModBiomes.bog, (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
    }
}

