/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.progwml6.natura.common.config.Config;
import maxhyper.dynamictreesnatura.ModContent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static Species maple;
    private static Species silverbell;
    private static Species amaranth;
    private static Species tigerwood;
    private static Species willow;
    private static Species eucalyptus;
    private static Species hopseed;
    private static Species sakura;
    private static Species ghostwood;
    private static Species bloodwood;
    private static Species fusewood;
    private static Species darkwood;
    private static Species saguaro;

    private static void createStaticAliases() {
        maple = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "maple"));
        silverbell = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "silverbell"));
        amaranth = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "amaranth"));
        tigerwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "tigerwood"));
        hopseed = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "hopseed"));
        willow = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "willow"));
        sakura = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "sakura"));
        eucalyptus = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "eucalyptus"));
        ghostwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "ghostwood"));
        bloodwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "bloodwood"));
        fusewood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "fusewood"));
        darkwood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "darkwood"));
        saguaro = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "saguaro"));
    }

    public void populate(BiomeDataBase dbase) {
        BiomeDataBasePopulator.createStaticAliases();
        Biome.field_185377_q.forEach(biome -> {
            BiomePropertySelectors.RandomSpeciesSelector selector;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(1000).add(sakura, ModContent.generateSakura ? 1 + 100 / Config.sakuraSpawnRarity / 5 : 0).add(eucalyptus, ModContent.generateEucalyptus ? 100 / Config.eucalyptusSpawnRarity : 0).add(maple, ModContent.generateMaple ? 100 / Config.mapleRarity : 0).add(silverbell, ModContent.generateSilverbell ? 100 / Config.silverbellRarity : 0).add(tigerwood, ModContent.generateTiger ? 100 / Config.tigerRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(eucalyptus, ModContent.generateEucalyptus ? 1 + (int)((double)(100 / Config.eucalyptusSpawnRarity) / 1.5) : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(500).add(hopseed, ModContent.generateHopseed ? 100 / Config.hopseedSpawnRarity : 0).add(eucalyptus, ModContent.generateEucalyptus ? 10 * (100 / Config.eucalyptusSpawnRarity) : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(500).add(sakura, ModContent.generateSakura ? 100 / Config.hopseedSpawnRarity : 0).add(willow, ModContent.generateWillow ? 100 / Config.eucalyptusSpawnRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(amaranth, ModContent.generateAmaranth ? 100 / Config.amaranthRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(500).add(willow, ModContent.generateWillow ? 100 / Config.willowRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(ghostwood, ModContent.generateGhostwood ? 100 / Config.ghostwoodSpawnRarity : 0).add(fusewood, ModContent.generateFusewood ? 100 / Config.fusewoodSpawnRarity : 0).add(darkwood, ModContent.generateDarkwood ? 100 / Config.darkwoodSpawnRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
                dbase.setDensitySelector(biome, (rand, noiseDensity) -> noiseDensity * 0.4, BiomeDataBase.Operation.REPLACE);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(20).add(saguaro, ModContent.generateSaguaro ? 10 / Config.saguaroSpawnRarity : 0);
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
        });
    }
}

