/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.nether.block.logs.BlockNetherLog;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesnatura.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeFusewood
extends TreeFamily {
    public static Block leavesBlock = NaturaNether.netherLeaves;
    public static Block logBlock = NaturaNether.netherLog;
    public static Block saplingBlock = NaturaNether.netherSapling;
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a((IProperty)BlockNetherLeaves.TYPE, (Comparable)BlockNetherLeaves.LeavesType.FUSEWOOD);

    public TreeFusewood() {
        super(new ResourceLocation("dynamictreesnatura", "fusewood"));
        this.setDynamicBranch(ModContent.fusewoodBranch);
        this.setPrimitiveLog(logBlock.func_176223_P().func_177226_a((IProperty)BlockNetherLog.TYPE, (Comparable)BlockNetherLog.LogType.FUSEWOOD));
        ModContent.fusewoodLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, 2);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        ItemStack stick = NaturaCommons.fusewood_stick;
        stick.func_190920_e(qty);
        return stick;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesFusewood(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesFusewood
    extends Species {
        SpeciesFusewood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.fusewoodLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 10.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.setSeedStack(new ItemStack((Item)ModContent.fusewoodSeed));
            this.setupStandardSeedDropping();
            this.addAcceptableSoils(new String[]{"netherlike"});
        }

        public BlockRooty getRootyBlock(World world, BlockPos pos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"netherlike"}))) {
                return ModContent.rootyNetherDirt;
            }
            return ModBlocks.blockRootyDirt;
        }
    }
}

