/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.logs.BlockNetherLog;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import maxhyper.dynamictreesnatura.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.util.LocUtils;

public class TreeDarkwood
extends TreeFamily {
    public static Block leavesBlock = NaturaNether.netherLeaves2;
    public static Block logBlock = NaturaNether.netherLog;
    public static Block saplingBlock = NaturaNether.netherSapling2;
    public static IBlockState leavesState = leavesBlock.func_176223_P();

    public TreeDarkwood() {
        super(new ResourceLocation("dynamictreesnatura", "darkwood"));
        this.setPrimitiveLog(logBlock.func_176223_P().func_177226_a((IProperty)BlockNetherLog.TYPE, (Comparable)BlockNetherLog.LogType.DARKWOOD));
        ModContent.darkwoodLeavesProperties.setTree((TreeFamily)this);
        ModContent.darkwoodFloweringLeavesProperties.setTree((TreeFamily)this);
        ModContent.darkwoodFruitLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, 1);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        ItemStack stick = NaturaCommons.darkwood_stick;
        stick.func_190920_e(qty);
        return stick;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDarkwood(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        return new BlockBranchBasic(branchName){

            public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
                return 0;
            }

            public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
                return 0;
            }
        };
    }

    public class SpeciesDarkwood
    extends Species {
        SpeciesDarkwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.darkwoodLeavesProperties);
            this.setBasicGrowingParameters(0.3f, 10.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            ModContent.blockPotashApple.setSpecies((Species)this);
            this.addGenFeature((IGenFeature)new FeatureGenFruit(ModContent.blockPotashApple).setRayDistance(4.0f));
            this.generateSeed();
            this.addAcceptableSoils(new String[]{"netherlike"});
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.addAll(LocUtils.getTooltips((String)(TextFormatting.GRAY.toString() + LocUtils.translateRecursive((String)LocUtils.translateRecursive((String)"tile.natura.nether_sapling.darkwood.tooltip", (Object[])new Object[0]), (Object[])new Object[0]))));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public BlockRooty getRootyBlock(World world, BlockPos pos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"netherlike"}))) {
                return ModContent.rootyNetherDirt;
            }
            return ModBlocks.blockRootyDirt;
        }
    }
}

