/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.trees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.cells.CellMetadata;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeDisease;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import maxhyper.dynamictreesnatura.ModContent;
import maxhyper.dynamictreesnatura.blocks.BlockDynamicSaplingBloodwood;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeBloodwood
extends TreeFamily {
    public static Block leavesBlock = NaturaNether.netherLeaves;
    public static Block logBlock = NaturaNether.netherLog2;
    public static Block saplingBlock = NaturaNether.netherSapling;
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a((IProperty)BlockNetherLeaves.TYPE, (Comparable)BlockNetherLeaves.LeavesType.BLOODWOOD);

    public TreeBloodwood() {
        super(new ResourceLocation("dynamictreesnatura", "bloodwood"));
        this.setDynamicBranch(ModContent.bloodwoodBranch);
        this.setPrimitiveLog(logBlock.func_176223_P());
        ModContent.bloodwoodLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, 0);
        stack.func_190920_e(net.minecraft.util.math.MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ItemStack getStick(int qty) {
        ItemStack stick = NaturaCommons.bloodwood_stick;
        stick.func_190920_e(qty);
        return stick;
    }

    public boolean isThick() {
        return true;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesBloodwood(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)ModContent.bloodwoodSapling);
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public int getRadiusForCellKit(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        int radius = branch.getRadius(blockState);
        int meta = 0;
        if (this.hasConiferVariants && radius == 1 && blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c() == branch) {
            meta = 1;
        }
        return CellMetadata.radiusAndMeta((int)radius, (int)meta);
    }

    public class SpeciesBloodwood
    extends Species {
        private final EnumFacing[] downFirst;

        SpeciesBloodwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.bloodwoodLeavesProperties);
            this.downFirst = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
            this.setBasicGrowingParameters(0.2f, 24.0f, 0, 10, 2.8f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"bloodwood"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.setSeedStack(new ItemStack((Item)ModContent.bloodwoodSeed));
            this.setupStandardSeedDropping();
            this.addAcceptableSoils(new String[]{"netherlike"});
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesBloodwood.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{Biomes.field_76778_j});
        }

        public boolean isThick() {
            return true;
        }

        public BlockRooty getRootyBlock(World world, BlockPos pos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"netherlike"}))) {
                return ModContent.rootyNetherUpsidedownDirt;
            }
            return ModContent.rootyUpsidedownDirt;
        }

        public boolean plantSapling(World world, BlockPos pos) {
            if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && BlockDynamicSaplingBloodwood.canSaplingStay(world, this, pos)) {
                ModContent.bloodwoodSapling.setSpecies(world, pos, (Species)this);
                return true;
            }
            return false;
        }

        public boolean transitionToTree(World world, BlockPos pos) {
            TreeFamily family = this.getFamily();
            if (world.func_175623_d(pos.func_177977_b()) && this.isAcceptableSoil(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()))) {
                family.getDynamicBranch().setRadius(world, pos, (int)family.getPrimaryThickness(), null);
                world.func_175656_a(pos.func_177977_b(), this.getLeavesProperties().getDynamicLeavesState());
                this.placeRootyDirtBlock(world, pos.func_177984_a(), 15);
                return true;
            }
            return false;
        }

        public AxisAlignedBB getSaplingBoundingBox() {
            return new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 1.0, 0.75);
        }

        public boolean handleRot(World world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
            Iterator<BlockPos> iter = ends.iterator();
            SimpleVoxmap leafMap = this.getLeavesProperties().getCellKit().getLeafCluster();
            while (iter.hasNext()) {
                float rotChance;
                int radius;
                BlockPos endPos = iter.next();
                IBlockState branchState = world.func_180495_p(endPos);
                BlockBranch branch = TreeHelper.getBranch((IBlockState)branchState);
                if (branch == null || !branch.checkForRot(world, endPos, (Species)this, radius = branch.getRadius(branchState), world.field_73012_v, rotChance = this.rotChance(world, endPos, world.field_73012_v, radius), safeBounds != SafeChunkBounds.ANY) && radius == 1) continue;
                if (safeBounds != SafeChunkBounds.ANY) {
                    TreeHelper.ageVolume((World)world, (BlockPos)endPos.func_177981_b((leafMap.getLenZ() - 1) / 2), (int)((leafMap.getLenX() - 1) / 2), (int)leafMap.getLenY(), (int)2, (SafeChunkBounds)safeBounds);
                }
                iter.remove();
            }
            return ends.isEmpty() && !TreeHelper.isBranch((IBlockState)world.func_180495_p(treePos));
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (radius <= 1) {
                BlockDynamicLeaves leaves = (BlockDynamicLeaves)this.getLeavesProperties().getDynamicLeavesState().func_177230_c();
                for (EnumFacing dir : this.downFirst) {
                    if (!leaves.growLeavesIfLocationIsSuitable(world, this.getLeavesProperties(), pos.func_177972_a(dir), 0)) continue;
                    return false;
                }
            }
            if (rapid || ModConfigs.maxBranchRotRadius != 0 && radius <= ModConfigs.maxBranchRotRadius) {
                BlockBranch branch = TreeHelper.getBranch((IBlockState)world.func_180495_p(pos));
                if (branch != null) {
                    branch.rot(world, pos);
                }
                return true;
            }
            return false;
        }

        public boolean handleDisease(World world, ITreePart baseTreePart, BlockPos treePos, Random random, int soilLife) {
            if (soilLife == 0 && ModConfigs.diseaseChance > random.nextFloat()) {
                baseTreePart.analyse(world.func_180495_p(treePos), world, treePos, EnumFacing.UP, new MapSignal(new INodeInspector[]{new NodeDisease((Species)this)}));
                return true;
            }
            return false;
        }

        public EnumFacing selectNewDirection(World world, BlockPos pos, BlockBranch branch, GrowSignal signal) {
            EnumFacing originDir = signal.dir.func_176734_d();
            if (signal.numSteps + 1 <= this.getLowestBranchHeight(world, signal.rootPos)) {
                return EnumFacing.DOWN;
            }
            int[] probMap = new int[6];
            probMap[EnumFacing.DOWN.ordinal()] = signal.dir != EnumFacing.UP ? this.getUpProbability() : 0;
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + this.getReinfTravel();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.equals((Object)originDir)) continue;
                BlockPos deltaPos = pos.func_177972_a(dir);
                IBlockState deltaBlockState = world.func_180495_p(deltaPos);
                int n2 = dir.func_176745_a();
                probMap[n2] = probMap[n2] + TreeHelper.getTreePart((IBlockState)deltaBlockState).probabilityForBlock(deltaBlockState, (IBlockAccess)world, deltaPos, branch);
            }
            probMap = this.customDirectionManipulation(world, pos, branch.getRadius(world.func_180495_p(pos)), signal, probMap);
            int choice = MathHelper.selectRandomFromDistribution((Random)signal.rand, (int[])probMap);
            return this.newDirectionSelected(EnumFacing.func_82600_a((int)(choice != -1 ? choice : 0)), signal);
        }
    }
}

