/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchCactus;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreator;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaroFruit;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import maxhyper.dynamictreesnatura.ModContent;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.util.LocUtils;

public class CactusSaguaro
extends TreeFamily {
    public static Block logBlock = NaturaOverworld.saguaro;

    public CactusSaguaro() {
        super(new ResourceLocation("dynamictreesnatura", "saguaro"));
        this.setPrimitiveLog(logBlock.func_176223_P());
        this.setStick(ItemStack.field_190927_a);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, 2);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public ILeavesProperties getCommonLeaves() {
        return (ILeavesProperties)ModBlocks.leaves.get(this.getName().func_110623_a());
    }

    public BlockBranch createBranch() {
        return new BlockBranchSaguaro();
    }

    public float getPrimaryThickness() {
        return 6.0f;
    }

    public float getSecondaryThickness() {
        return 5.0f;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesCactus(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        this.getCommonSpecies().generateSeed();
    }

    protected class JoCodeCactus
    extends JoCode {
        public JoCodeCactus(String code) {
            super(code);
        }

        public void generate(World world, Species species, BlockPos rootPos, Biome biome, EnumFacing facing, int radius, SafeChunkBounds safeBounds) {
            IBlockState initialDirtState = world.func_180495_p(rootPos);
            species.placeRootyDirtBlock(world, rootPos, 0);
            radius = MathHelper.func_76125_a((int)radius, (int)2, (int)8);
            BlockPos treePos = rootPos.func_177984_a();
            this.setFacing(facing);
            this.generateFork(world, species, 0, rootPos, false);
            BlockBranch branch = TreeHelper.getBranch((IBlockState)world.func_180495_p(treePos));
            if (branch != null) {
                NodeFindEnds endFinder = new NodeFindEnds();
                MapSignal signal = new MapSignal(new INodeInspector[]{endFinder});
                branch.analyse(world.func_180495_p(treePos), world, treePos, EnumFacing.DOWN, signal);
                List endPoints = endFinder.getEnds();
                species.postGeneration(world, rootPos, biome, radius, endPoints, safeBounds, initialDirtState);
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(world, species, rootPos, endPoints, safeBounds, initialDirtState));
            } else {
                world.func_180501_a(rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }

        public boolean setBlockForGeneration(World world, Species species, BlockPos pos, EnumFacing dir, boolean careful) {
            IBlockState defaultBranchState = species.getFamily().getDynamicBranch().func_176223_P();
            if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                IBlockState downState;
                boolean trunk = false;
                if (dir == EnumFacing.UP && (TreeHelper.isRooty((IBlockState)(downState = world.func_180495_p(pos.func_177977_b()))) || downState.func_177230_c() == defaultBranchState.func_177230_c() && ((Boolean)downState.func_177229_b((IProperty)BlockBranchCactus.TRUNK)).booleanValue() && downState.func_177229_b((IProperty)BlockBranchCactus.ORIGIN) == EnumFacing.DOWN)) {
                    trunk = true;
                }
                return !world.func_180501_a(pos, defaultBranchState.func_177226_a((IProperty)BlockBranchCactus.TRUNK, (Comparable)Boolean.valueOf(trunk)).func_177226_a((IProperty)BlockBranchCactus.ORIGIN, (Comparable)dir.func_176734_d()), careful ? 3 : 2);
            }
            return true;
        }
    }

    private class BlockBranchSaguaro
    extends BlockBranchCactus {
        public BlockBranchSaguaro() {
            super("dynamictreesnatura:saguarobranch");
            this.func_149675_a(true);
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (worldIn.func_72912_H().func_76059_o() && worldIn.func_175623_d(pos.func_177984_a())) {
                boolean canGrow;
                float fruitFactor = SeasonHelper.globalSeasonalFruitProductionFactor((World)worldIn, (BlockPos)pos);
                if (fruitFactor <= 0.0f) {
                    return;
                }
                boolean bl = canGrow = rand.nextInt((int)(20.0f / fruitFactor)) == 0;
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)canGrow)) {
                    switch (rand.nextInt(4)) {
                        case 0: {
                            if (!worldIn.func_175623_d(pos.func_177978_c())) break;
                            worldIn.func_180501_a(pos.func_177978_c(), NaturaOverworld.saguaroFruit.func_176223_P().func_177226_a((IProperty)BlockSaguaroFruit.FACING, (Comparable)EnumFacing.SOUTH), 3);
                            break;
                        }
                        case 1: {
                            if (!worldIn.func_175623_d(pos.func_177974_f())) break;
                            worldIn.func_180501_a(pos.func_177974_f(), NaturaOverworld.saguaroFruit.func_176223_P().func_177226_a((IProperty)BlockSaguaroFruit.FACING, (Comparable)EnumFacing.WEST), 3);
                            break;
                        }
                        case 2: {
                            if (!worldIn.func_175623_d(pos.func_177968_d())) break;
                            worldIn.func_180501_a(pos.func_177968_d(), NaturaOverworld.saguaroFruit.func_176223_P().func_177226_a((IProperty)BlockSaguaroFruit.FACING, (Comparable)EnumFacing.NORTH), 3);
                            break;
                        }
                        case 3: {
                            if (!worldIn.func_175623_d(pos.func_177976_e())) break;
                            worldIn.func_180501_a(pos.func_177976_e(), NaturaOverworld.saguaroFruit.func_176223_P().func_177226_a((IProperty)BlockSaguaroFruit.FACING, (Comparable)EnumFacing.EAST), 3);
                        }
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public class SpeciesCactus
    extends Species {
        SpeciesCactus(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.cactusLeavesProperties);
            this.setBasicGrowingParameters(0.875f, 6.0f, 6, 2, 1.0f);
            this.setSoilLongevity(1);
            this.generateSeed();
            this.addDropCreator((IDropCreator)new DropCreator(new ResourceLocation("dynamictrees", "saguaroseeds")){

                public List<ItemStack> getLogsDrop(World world, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, float volume) {
                    for (int numLogs = (int)(volume / 2.0f); numLogs > 0; numLogs -= 64) {
                        dropList.add(species.getSeedStack(Math.min(numLogs, 64)));
                    }
                    return dropList;
                }
            });
            this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.SANDY, 1.05f);
            this.clearAcceptableSoils();
            this.addAcceptableSoils(new String[]{"sandlike"});
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.addAll(LocUtils.getTooltips((String)(TextFormatting.GRAY.toString() + LocUtils.translateRecursive((String)LocUtils.translateRecursive((String)"tile.natura.saguaro.tooltip", (Object[])new Object[0]), (Object[])new Object[0]))));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public JoCode getJoCode(String joCodeString) {
            return new JoCodeCactus(joCodeString);
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_82737_E() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)2) % 3);
        }

        public BlockRooty getRootyBlock(World world, BlockPos pos) {
            return ModBlocks.blockRootySand;
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesCactus.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R});
        }

        public boolean handleRot(World world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
            return false;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = signal.delta.func_177958_n() % 2 == 0 || signal.delta.func_177952_p() % 2 == 0 ? this.getUpProbability() : 0;
            probMap[5] = signal.isInTrunk() && signal.energy > 1.0f ? 1 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            if (signal.dir != EnumFacing.UP) {
                probMap[signal.dir.ordinal()] = 0;
            }
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy += 0.0f;
            }
            return newDir;
        }

        public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
            if (!(this.getSubstanceEffect(itemStack) instanceof SubstanceTransform)) {
                return super.applySubstance(world, rootPos, hitPos, player, hand, itemStack);
            }
            return false;
        }

        public boolean canBoneMeal() {
            return false;
        }

        public boolean transitionToTree(World world, BlockPos pos) {
            TreeFamily tree = this.getFamily();
            if (world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()))) {
                world.func_175656_a(pos, tree.getDynamicBranch().func_176223_P());
                this.placeRootyDirtBlock(world, pos.func_177977_b(), 15);
                return true;
            }
            return false;
        }

        public AxisAlignedBB getSaplingBoundingBox() {
            return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);
        }

        public SoundType getSaplingSound() {
            return SoundType.field_185854_g;
        }
    }
}

