/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.proxy;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import java.awt.Color;
import maxhyper.dynamictreesnatura.ModContent;
import maxhyper.dynamictreesnatura.event.EventListenerNatura;
import maxhyper.dynamictreesnatura.items.ItemDynamicSeedBloodwood;
import maxhyper.dynamictreesnatura.items.ItemDynamicSeedMaple;
import maxhyper.dynamictreesnatura.model.ModelLoaderBlockBranchBloodwood;
import maxhyper.dynamictreesnatura.proxy.CommonProxy;
import maxhyper.dynamictreesnatura.renderer.RenderBloodwoodSeed;
import maxhyper.dynamictreesnatura.renderer.RenderMapleSeed;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerEntityRenderers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBlockBranchBloodwood());
        MinecraftForge.EVENT_BUS.register((Object)new EventListenerNatura());
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    public void registerColorHandlers() {
        for (BlockDynamicLeaves leaves : LeavesPaging.getLeavesMapForModId((String)"dynamictreesnatura").values()) {
            ModelHelper.regColorHandler((Block)leaves, (state, worldIn, pos, tintIndex) -> {
                Block block = state.func_177230_c();
                if (TreeHelper.isLeaves((Block)block)) {
                    return ((BlockDynamicLeaves)block).getProperties(state).foliageColorMultiplier(state, worldIn, pos);
                }
                return 0xFF00FF;
            });
        }
        int white = -1;
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (state.func_177230_c() instanceof BlockRooty) {
                BlockRooty blockRooty = (BlockRooty)state.func_177230_c();
                switch (tintIndex) {
                    case 0: {
                        IBlockState muse = blockRooty.getMimic(world, pos);
                        if (!(muse instanceof MimicProperty.IMimic)) {
                            return blockColors.func_186724_a(muse, world, pos, tintIndex);
                        }
                    }
                    case 1: {
                        return blockRooty.rootColor(state, world, pos);
                    }
                }
                return -1;
            }
            return -1;
        }, new Block[]{ModContent.rootyNetherDirt, ModContent.rootyNetherUpsidedownDirt, ModContent.rootyUpsidedownDirt});
    }

    public static int addHexColor(Color color, int add) {
        int R = Math.min(255, color.getRed() + add);
        int G = Math.min(255, color.getGreen() + add);
        int B = Math.min(255, color.getBlue() + add);
        return new Color(R, G, B).getRGB();
    }

    public void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ItemDynamicSeedBloodwood.EntityItemBloodwoodSeed.class, (IRenderFactory)new RenderBloodwoodSeed.Factory());
        RenderingRegistry.registerEntityRenderingHandler(ItemDynamicSeedMaple.EntityItemMapleSeed.class, (IRenderFactory)new RenderMapleSeed.Factory());
    }
}

