/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.model;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchCactus;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockBranchSaguaro
implements IBakedModel {
    protected ModelBlock modelBlock;
    TextureAtlasSprite barkParticles;
    private IBakedModel[][] sleeves = new IBakedModel[6][2];
    private IBakedModel[][] cores = new IBakedModel[3][2];
    private IBakedModel[] rings = new IBakedModel[2];
    private IBakedModel[] coreSpikes = new IBakedModel[2];
    private IBakedModel sleeveTopSpikes;

    public BakedModelBlockBranchSaguaro(ResourceLocation barkRes, ResourceLocation ringsRes, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.modelBlock = new ModelBlock(null, null, null, false, false, ItemCameraTransforms.field_178357_a, null);
        TextureAtlasSprite barkIcon = bakedTextureGetter.apply(barkRes);
        TextureAtlasSprite ringIcon = bakedTextureGetter.apply(ringsRes);
        this.barkParticles = barkIcon;
        for (int i = 0; i < 2; ++i) {
            int radius = i + 4;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.sleeves[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, barkIcon, ringIcon);
            }
            this.cores[0][i] = this.bakeCore(radius, EnumFacing.Axis.Y, barkIcon);
            this.cores[1][i] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIcon);
            this.cores[2][i] = this.bakeCore(radius, EnumFacing.Axis.X, barkIcon);
            this.rings[i] = this.bakeCore(radius, EnumFacing.Axis.Y, ringIcon);
            this.coreSpikes[i] = this.bakeCoreSpikes(radius, barkIcon);
            this.sleeveTopSpikes = this.bakeTopSleeveSpikes(barkIcon);
        }
    }

    public IBakedModel bakeSleeve(int radius, EnumFacing dir, TextureAtlasSprite bark, TextureAtlasSprite top) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeY = dir.func_96559_d() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerY = 16 + dir.func_96559_d() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), (float)((centerY - halfSizeY) / 2), (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)((centerY + halfSizeY) / 2), (float)((centerZ + halfSizeZ) / 2));
        boolean bl = negative = dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 4 || radius == 5 && dir == EnumFacing.DOWN) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)(dir == face ? top : bark), (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        float minV = negative ? (float)(16 - halfSize) : 0.0f;
        float maxV = negative ? 16.0f : (float)halfSize;
        switch (dir.func_176740_k()) {
            case X: {
                builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 2.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, minV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 2.0f, minV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
                break;
            }
            case Y: {
                builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 16.0f, minV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 2.0f, minV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
                break;
            }
            case Z: {
                builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 2.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 16.0f, minV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 2.0f, minV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
                builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, EnumFacing.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)icon, (EnumFacing)face, (ITransformation)ModelRotation.X0_Y0, (boolean)false));
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCoreSpikes(int radius, TextureAtlasSprite bark) {
        float minV = 8 - radius;
        float maxV = 8 + radius;
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 2.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, minV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 2.0f, minV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posFrom.y / 16.0f - 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.SOUTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.NORTH, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.001f, posTo.y / 16.0f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 16.0f, minV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f, posFrom.z / 16.0f - 0.001f, -1, bark, 2.0f, minV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f, posTo.z / 16.0f + 0.001f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.DOWN, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posFrom.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 2.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 16.0f, minV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 2.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posFrom.y / 16.0f - 0.001f, posFrom.z / 16.0f, -1, bark, 2.0f, minV)}), 0, EnumFacing.DOWN, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.EAST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.WEST, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        return builder.func_177645_b();
    }

    public IBakedModel bakeTopSleeveSpikes(TextureAtlasSprite bark) {
        float minV = 4.0f;
        float maxV = 12.0f;
        Vector3f posFrom = new Vector3f(4.0f, 16.0f, 4.0f);
        Vector3f posTo = new Vector3f(12.0f, 16.0f, 12.0f);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f - 0.002f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.NORTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f + 0.002f, -1, bark, 16.0f, minV)}), 0, EnumFacing.SOUTH, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f + 0.0625f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posTo.z / 16.0f - 0.0625f, -1, bark, 14.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, maxV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f + 0.0625f, -1, bark, 2.0f, minV), this.vertexToInts(posTo.x / 16.0f, posTo.y / 16.0f + 0.002f, posFrom.z / 16.0f - 0.0625f, -1, bark, 0.0f, minV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posFrom.x / 16.0f - 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.WEST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posTo.z / 16.0f, -1, bark, 16.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f - 0.0625f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f + 0.002f, posTo.y / 16.0f + 0.0625f, posFrom.z / 16.0f, -1, bark, 16.0f, minV)}), 0, EnumFacing.EAST, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 16.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 14.0f, minV), this.vertexToInts(posTo.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 14.0f, maxV), this.vertexToInts(posTo.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 16.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        builder.func_177650_a(EnumFacing.UP, new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 2.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posFrom.z / 16.0f, -1, bark, 0.0f, minV), this.vertexToInts(posFrom.x / 16.0f - 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 0.0f, maxV), this.vertexToInts(posFrom.x / 16.0f + 0.0625f, posTo.y / 16.0f + 0.001f, posTo.z / 16.0f, -1, bark, 2.0f, maxV)}), 0, EnumFacing.UP, bark, true, DefaultVertexFormats.field_176600_a));
        return builder.func_177645_b();
    }

    public int getFaceAngle(EnumFacing.Axis axis, EnumFacing face) {
        if (axis == EnumFacing.Axis.Y) {
            return 0;
        }
        if (axis == EnumFacing.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == EnumFacing.NORTH ? 270 : 90;
    }

    protected int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(12);
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
        if (blockState instanceof IExtendedBlockState) {
            EnumFacing coreRingDir;
            EnumFacing sourceDir;
            int coreRadius = this.getRadius(blockState);
            int[] connections = this.pollConnections(coreRadius, extendedBlockState);
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            boolean extraUpSleeve = false;
            if (coreRadius == 4 && numConnections == 1 && ((EnumFacing)((IExtendedBlockState)blockState).func_177229_b((IProperty)BlockBranchCactus.ORIGIN)).func_176740_k().func_176722_c()) {
                connections[1] = 4;
                extraUpSleeve = true;
            }
            if ((sourceDir = this.getSourceDir(coreRadius, connections)) == null) {
                sourceDir = EnumFacing.DOWN;
            }
            int coreDir = this.resolveCoreDir(sourceDir);
            EnumFacing enumFacing = coreRingDir = numConnections == 1 ? sourceDir.func_176734_d() : null;
            if (side == null || coreRadius != connections[side.func_176745_a()]) {
                if (coreRingDir == null || coreRingDir != side) {
                    quadsList.addAll(this.cores[coreDir][coreRadius - 4].func_188616_a(blockState, side, rand));
                } else {
                    quadsList.addAll(this.rings[coreRadius - 4].func_188616_a(blockState, side, rand));
                }
            }
            for (EnumFacing connDir : EnumFacing.field_82609_l) {
                int idx = connDir.func_176745_a();
                int connRadius = connections[idx];
                if (connRadius <= 0 || (connDir != EnumFacing.UP || connRadius != 4 || !extraUpSleeve) && side == connDir && connDir != EnumFacing.DOWN) continue;
                quadsList.addAll(this.sleeves[idx][connRadius - 4].func_188616_a((IBlockState)extendedBlockState, side, rand));
            }
        }
        return quadsList;
    }

    protected int[] pollConnections(int coreRadius, IExtendedBlockState extendedBlockState) {
        int[] connections = new int[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connection = this.getConnectionRadius(extendedBlockState, (IUnlistedProperty<Integer>)BlockBranch.CONNECTIONS[dir.func_176745_a()]);
            connections[dir.func_176745_a()] = MathHelper.func_76125_a((int)connection, (int)0, (int)coreRadius);
        }
        return connections;
    }

    protected EnumFacing getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        EnumFacing sourceDir = null;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = connections[dir.func_176745_a()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(EnumFacing dir) {
        return dir.func_176745_a() >> 1;
    }

    protected int getRadius(IBlockState blockState) {
        return ((BlockBranchCactus)blockState.func_177230_c()).getRadius(blockState);
    }

    protected int getConnectionRadius(IExtendedBlockState iExtendedBlockState, IUnlistedProperty<Integer> whichConnection) {
        Integer connection = (Integer)iExtendedBlockState.getValue(whichConnection);
        return connection != null ? connection : 0;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkParticles;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

