/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.items;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.util.LocUtils;

public class ItemDynamicSeedBloodwood
extends Seed {
    public ItemDynamicSeedBloodwood() {
        super(new ResourceLocation("dynamictreesnatura", "bloodwoodseed").toString());
    }

    public boolean doPlanting(World world, BlockPos pos, EntityPlayer planter, ItemStack seedStack) {
        Species species = this.getSpecies(seedStack);
        if (species.plantSapling(world, pos)) {
            String joCode = this.getCode(seedStack);
            if (!joCode.isEmpty()) {
                world.func_175698_g(pos);
                species.getJoCode(joCode).setCareful(true).generate(world, species, pos.func_177984_a(), world.func_180494_b(pos), planter != null ? planter.func_174811_aO() : EnumFacing.NORTH, 8, SafeChunkBounds.ANY);
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(LocUtils.getTooltips((String)(TextFormatting.GRAY.toString() + LocUtils.translateRecursive((String)LocUtils.translateRecursive((String)"tile.natura.nether_sapling2.bloodwood.tooltip", (Object[])new Object[0]), (Object[])new Object[0]))));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public EnumActionResult onItemUsePlantSeed(EntityPlayer player, World world, BlockPos pos, EnumHand hand, ItemStack seedStack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177984_a();
            facing = EnumFacing.DOWN;
        }
        if (facing == EnumFacing.DOWN && player.func_175151_a(pos, facing, seedStack) && player.func_175151_a(pos.func_177977_b(), facing, seedStack) && this.doPlanting(world, pos.func_177977_b(), player, seedStack)) {
            seedStack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityItemBloodwoodSeed bloodwoodSeedEntity = new EntityItemBloodwoodSeed(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        bloodwoodSeedEntity.field_70159_w = location.field_70159_w;
        bloodwoodSeedEntity.field_70181_x = location.field_70181_x;
        bloodwoodSeedEntity.field_70179_y = location.field_70179_y;
        return bloodwoodSeedEntity;
    }

    public static class EntityItemBloodwoodSeed
    extends EntityItem {
        public int seedsPlantedPerStack = 16;
        public float chanceToPlant = ModConfigs.seedPlantRate;

        public EntityItemBloodwoodSeed(World worldIn) {
            super(worldIn);
        }

        public EntityItemBloodwoodSeed(World worldIn, double x, double y, double z, ItemStack stack) {
            super(worldIn, x, y, z, stack);
            this.func_174869_p();
        }

        public void func_70071_h_() {
            this.field_70181_x += (double)0.041f;
            IBlockState thisState = this.field_70170_p.func_180495_p(this.func_180425_c());
            Species thisSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesnatura", "bloodwood"));
            if (this.func_92059_d().func_190916_E() > 0 && !this.field_70128_L && this.field_70173_aa % (ModConfigs.seedTimeToLive / this.seedsPlantedPerStack) == 0 && thisSpecies.isAcceptableSoil(this.field_70170_p, this.func_180425_c(), thisState) && this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
                boolean FAIL = false;
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    if (!(this.field_70170_p.func_180495_p(this.func_180425_c().func_177972_a(dir)).func_177230_c() instanceof BlockRooty)) continue;
                    FAIL = true;
                }
                if (!FAIL && this.field_70170_p.field_73012_v.nextFloat() <= this.chanceToPlant) {
                    thisSpecies.plantSapling(this.field_70170_p, this.func_180425_c().func_177977_b());
                    if (this.func_92059_d().func_190916_E() > 1) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                        this.field_70181_x -= (double)0.2f;
                        this.field_70159_w += (double)(this.field_70170_p.field_73012_v.nextFloat() / 2.0f - 0.25f);
                        this.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() / 2.0f - 0.25f);
                    }
                }
                this.func_92059_d().func_190918_g(1);
                this.field_70173_aa = 0;
            }
            super.func_70071_h_();
        }

        public void func_174869_p() {
            this.func_174867_a(50);
        }
    }
}

