/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.growth;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.cells.CellAcaciaLeaf;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CustomCellKits
extends CellKits {
    private final ICellKit bloodwood = new ICellKit(){
        private final ICell bloodwoodBranch = new ICell(){
            final int[] map = new int[]{3, 0, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(EnumFacing side) {
                return this.map[side.ordinal()];
            }
        };
        private final ICell[] acaciaLeafCells = new ICell[]{CellNull.NULLCELL, new CellAcaciaLeaf(1), new CellAcaciaLeaf(2), new CellAcaciaLeaf(3), new CellAcaciaLeaf(4)};
        private final CellKits.BasicSolver bloodwoodSolver = new CellKits.BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        public ICell getCellForLeaves(int hydro) {
            return this.acaciaLeafCells[hydro];
        }

        public ICell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.bloodwoodBranch : CellNull.NULLCELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.darkoak;
        }

        public ICellSolver getCellSolver() {
            return this.bloodwoodSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };

    public CustomCellKits() {
        TreeRegistry.registerCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "bloodwood"), (ICellKit)this.bloodwood);
    }
}

