/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRootyUpsideDown
extends BlockRooty {
    static String name = "rootydirtupsidedown";
    public static final Material[] materialOrder = new Material[]{Material.field_151577_b, Material.field_151578_c};

    public BlockRootyUpsideDown(boolean isTileEntity) {
        this(name + (isTileEntity ? "species" : ""), isTileEntity);
    }

    public BlockRootyUpsideDown(String name, boolean isTileEntity) {
        super(name, Material.field_151578_c, isTileEntity);
    }

    public BlockRootyUpsideDown(String name, Material material, boolean isTileEntity) {
        super(name, material, isTileEntity);
    }

    public void updateTree(IBlockState rootyState, World world, BlockPos rootPos, Random random, boolean natural) {
        super.updateTree(rootyState, world, rootPos, random, natural);
        int halfWidth = 8;
        int height = 31;
        int iterations = 1;
        SafeChunkBounds safeBounds = SafeChunkBounds.ANY;
        Iterable iterable = BlockPos.func_177975_b((BlockPos)rootPos.func_177971_a((Vec3i)new BlockPos(-halfWidth, -height, -halfWidth)), (BlockPos)rootPos.func_177971_a((Vec3i)new BlockPos(halfWidth, 0, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos.MutableBlockPos iPos : iterable) {
                IBlockState blockState = world.func_180495_p((BlockPos)iPos);
                Block block = blockState.func_177230_c();
                if (!(block instanceof IAgeable)) continue;
                ((IAgeable)block).age(world, (BlockPos)iPos, blockState, world.field_73012_v, safeBounds);
            }
        }
    }

    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return MimicProperty.getGenericMimic((IBlockAccess)access, (BlockPos)pos, (Material[])materialOrder, (int)DirtHelper.getSoilFlags((String[])new String[]{"dirtlike"}), (IBlockState)ModBlocks.blockStates.dirt);
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return this.getMimic(access, pos);
    }

    public EnumFacing getTrunkDirection(IBlockAccess access, BlockPos rootPos) {
        return EnumFacing.DOWN;
    }

    public void destroyTree(World world, BlockPos rootPos) {
        Optional branch = TreeHelper.getBranchOpt((IBlockState)world.func_180495_p(rootPos.func_177977_b()));
        if (branch.isPresent()) {
            BranchDestructionData destroyData = ((BlockBranch)branch.get()).destroyBranchFromNode(world, rootPos.func_177977_b(), EnumFacing.UP, true);
            EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, new ArrayList(0), (EntityFallingTree.DestroyType)EntityFallingTree.DestroyType.ROOT);
        }
    }

    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return dir == EnumFacing.UP ? BlockBranch.setSupport((int)1, (int)1) : 0;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.SOLID;
    }
}

