/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesnatura.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeDestroyer;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeExtState;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeSpecies;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockDynamicBranchBloodwood
extends BlockBranchThick {
    public BlockDynamicBranchBloodwood() {
        super(new ResourceLocation("dynamictreesnatura", "bloodwoodbranch").toString());
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(blockState);
        return 2.0f * (float)(radius * radius) / 64.0f * 8.0f;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getMaxRadius() {
        return 16;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public BranchDestructionData destroyBranchFromNode(World world, BlockPos cutPos, EnumFacing toolDir, boolean wholeTree) {
        IBlockState blockState = world.func_180495_p(cutPos);
        NodeSpecies nodeSpecies = new NodeSpecies();
        MapSignal signal = this.analyse(blockState, world, cutPos, null, new MapSignal(new INodeInspector[]{nodeSpecies}));
        Species species = nodeSpecies.getSpecies();
        NodeExtState extStateMapper = new NodeExtState(cutPos);
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new INodeInspector[]{extStateMapper}));
        NodeNetVolume volumeSum = new NodeNetVolume();
        NodeDestroyer destroyer = new NodeDestroyer(species);
        destroyMode = BlockBranch.EnumDestroyMode.HARVEST;
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new INodeInspector[]{volumeSum, destroyer}));
        destroyMode = BlockBranch.EnumDestroyMode.SLOPPY;
        List endPoints = destroyer.getEnds();
        HashMap destroyedLeaves = new HashMap();
        ArrayList leavesDropsList = new ArrayList();
        this.destroyLeaves(world, cutPos, species, endPoints, destroyedLeaves, leavesDropsList);
        endPoints = endPoints.stream().map(p -> p.func_177973_b((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (extStateMapper.getExtStateMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.func_177977_b();
        }
        EnumFacing cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = EnumFacing.UP;
        }
        return new BranchDestructionData(species, extStateMapper.getExtStateMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
    }

    public void futureBreak(IBlockState state, World world, BlockPos cutPos, EntityLivingBase entity) {
        double reachDistance = entity instanceof EntityPlayerMP ? entity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0;
        RayTraceResult rtResult = this.playerRayTrace(entity, reachDistance, 1.0f);
        EnumFacing toolDir = rtResult != null ? (entity.func_70093_af() ? rtResult.field_178784_b.func_176734_d() : rtResult.field_178784_b) : EnumFacing.UP;
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, toolDir, false);
        ItemStack heldItem = entity.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        float woodVolume = destroyData.woodVolume;
        List woodItems = this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor);
        if (entity.func_184600_cs() == null) {
            entity.func_184598_c(EnumHand.MAIN_HAND);
        }
        float chance = 1.0f;
        if (entity instanceof EntityPlayer) {
            chance = ForgeEventFactory.fireBlockHarvesting((List)woodItems, (World)world, (BlockPos)cutPos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)entity));
        }
        float finalChance = chance;
        List woodDropList = woodItems.stream().filter(i -> world.field_73012_v.nextFloat() <= finalChance).collect(Collectors.toList());
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, woodDropList, (EntityFallingTree.DestroyType)EntityFallingTree.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume);
    }

    protected void sloppyBreak(World world, BlockPos cutPos, EntityFallingTree.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, EnumFacing.UP, false);
        List woodDropList = this.getLogDrops(world, cutPos, destroyData.species, destroyData.woodVolume);
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, (List)woodDropList, (EntityFallingTree.DestroyType)destroyType);
    }

    protected int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        IBlockState blockState = blockAccess.func_180495_p(deltaPos);
        int connectionRadius = TreeHelper.getTreePart((IBlockState)blockState).getRadiusForConnection(blockState, blockAccess, deltaPos, (BlockBranch)this, side, radius);
        if (radius > 8) {
            if (side == EnumFacing.UP) {
                return connectionRadius >= radius ? 1 : 0;
            }
            if (side == EnumFacing.DOWN) {
                return connectionRadius >= radius ? 2 : (connectionRadius > 0 ? 1 : 0);
            }
        }
        return Math.min(8, connectionRadius);
    }

    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.dir == EnumFacing.UP) {
            signal.dir = EnumFacing.DOWN;
            signal.numTurns = 0;
        }
        return super.growSignal(world, pos, signal);
    }
}

