/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.trailer.EntityFertilizerTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityFluidTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntitySeederTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityVehicleTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.EntityATV;
import com.mrcrayfish.vehicle.entity.vehicle.EntityAluminumBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBath;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBumperCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntityCouch;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDirtBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDuneBuggy;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGoKart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGolfCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityJetSki;
import com.mrcrayfish.vehicle.entity.vehicle.EntityLawnMower;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBus;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMoped;
import com.mrcrayfish.vehicle.entity.vehicle.EntityOffRoader;
import com.mrcrayfish.vehicle.entity.vehicle.EntityShoppingCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySmartCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySofacopter;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySpeedBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySportsPlane;
import com.mrcrayfish.vehicle.entity.vehicle.EntityTractor;
import com.mrcrayfish.vehicle.init.ModItems;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class VehicleRecipes {
    public static final ImmutableMap<Class<? extends EntityVehicle>, VehicleRecipe> RECIPES;

    @Nullable
    public static VehicleRecipe getRecipe(Class<? extends Entity> clazz) {
        return (VehicleRecipe)RECIPES.get(clazz);
    }

    public static int getVehicleCount() {
        return RECIPES.size();
    }

    public static List<Class<? extends EntityVehicle>> getVehicleClasses() {
        return ImmutableList.copyOf((Collection)RECIPES.keySet());
    }

    static {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        Builder builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 80));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 10));
        mapBuilder.put(EntityAluminumBoat.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 64));
        builder.addMaterial(new ItemStack(Blocks.field_150411_aY, 4));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 4, 15));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 6));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 8));
        mapBuilder.put(EntityATV.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 8));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 8));
        mapBuilder.put(EntityBumperCar.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 2, EnumDyeColor.GRAY.func_176765_a()));
        mapBuilder.put(EntityDirtBike.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Blocks.field_192443_dR, 16, EnumDyeColor.YELLOW.func_176765_a()));
        builder.addMaterial(new ItemStack(Blocks.field_192443_dR, 8, EnumDyeColor.BLUE.func_176765_a()));
        builder.addMaterial(new ItemStack(Blocks.field_192443_dR, 4, EnumDyeColor.RED.func_176765_a()));
        mapBuilder.put(EntityDuneBuggy.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 4));
        mapBuilder.put(EntityGoKart.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 128));
        builder.addMaterial(new ItemStack(Blocks.field_150411_aY, 4));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 8, 0));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 12));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 16));
        mapBuilder.put(EntityGolfCart.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 80));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 10));
        mapBuilder.put(EntityJetSki.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 64));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 4, 15));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 8));
        mapBuilder.put(EntityLawnMower.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 24));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 2, 15));
        mapBuilder.put(EntityMiniBike.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 128));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 5, EnumDyeColor.GRAY.func_176765_a()));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 9));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 12));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 16));
        mapBuilder.put(EntityMiniBus.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(Blocks.field_150411_aY, 2));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 4, 15));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 6));
        mapBuilder.put(EntityMoped.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 150));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 8, 15));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 6));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 12));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 24));
        mapBuilder.put(EntityOffRoader.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 8));
        builder.addMaterial(new ItemStack(Blocks.field_150411_aY, 4));
        builder.addMaterial(new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        mapBuilder.put(EntityShoppingCart.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 80));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 8, 15));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 6));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 8));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 16));
        mapBuilder.put(EntitySmartCar.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 80));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 8, 15));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 4));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 10));
        mapBuilder.put(EntitySpeedBoat.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 180));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 16));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 18));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 32));
        mapBuilder.put(EntitySportsPlane.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 128));
        builder.addMaterial(new ItemStack(Blocks.field_150325_L, 4, 15));
        builder.addMaterial(new ItemStack(Items.field_151137_ax, 8));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 16));
        mapBuilder.put(EntityTractor.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 48));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 2));
        mapBuilder.put(EntityVehicleTrailer.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 2));
        builder.addMaterial(new ItemStack((Block)Blocks.field_150486_ae));
        mapBuilder.put(EntityStorageTrailer.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 42));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 8));
        mapBuilder.put(EntitySeederTrailer.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 36));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 8));
        mapBuilder.put(EntityFertilizerTrailer.class, (Object)builder.build());
        builder = new Builder();
        builder.addMaterial(new ItemStack(Items.field_151042_j, 48));
        builder.addMaterial(new ItemStack(ModItems.PANEL, 16));
        builder.addMaterial(new ItemStack(Blocks.field_150410_aZ, 2));
        mapBuilder.put(EntityFluidTrailer.class, (Object)builder.build());
        if (Loader.isModLoaded((String)"cfm")) {
            builder = new Builder();
            builder.addMaterial(new ItemStack(Item.func_111206_d((String)"cfm:bath_bottom"), 1));
            builder.addMaterial(new ItemStack(Items.field_151156_bN, 1));
            mapBuilder.put(EntityBath.class, (Object)builder.build());
            builder = new Builder();
            builder.addMaterial(new ItemStack(Item.func_111206_d((String)"cfm:couch_jeb"), 1));
            builder.addMaterial(new ItemStack(Items.field_151042_j, 8));
            mapBuilder.put(EntityCouch.class, (Object)builder.build());
            builder = new Builder();
            builder.addMaterial(new ItemStack(Item.func_111206_d((String)"cfm:couch"), 1, 14));
            builder.addMaterial(new ItemStack(Item.func_111206_d((String)"cfm:ceiling_fan")));
            builder.addMaterial(new ItemStack(Items.field_151042_j, 16));
            mapBuilder.put(EntitySofacopter.class, (Object)builder.build());
        }
        RECIPES = mapBuilder.build();
    }

    public static class Builder {
        private Set<ItemStack> materials = new LinkedHashSet<ItemStack>();

        public void addMaterial(ItemStack stack) {
            this.materials.add(stack);
        }

        public VehicleRecipe build() {
            return new VehicleRecipe(this.materials);
        }
    }

    public static class VehicleRecipe {
        private final ImmutableList<ItemStack> materials;

        public VehicleRecipe(Set<ItemStack> materialSet) {
            this.materials = ImmutableList.copyOf(materialSet);
        }

        public ImmutableList<ItemStack> getMaterials() {
            return this.materials;
        }
    }
}

