/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.tileentity.TileEntityBoost;
import com.mrcrayfish.vehicle.util.Bounds;
import com.mrcrayfish.vehicle.util.StateHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBoostRamp
extends BlockRotatedObject {
    public static final PropertyBool STACKED = PropertyBool.func_177716_a((String)"stacked");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    private static final AxisAlignedBB COLLISION_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB COLLISION_STACKED_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    private static final AxisAlignedBB[] COLLISION_ONE = new Bounds(2, 1, 0, 16, 2, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_TWO = new Bounds(4, 2, 0, 16, 3, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_THREE = new Bounds(6, 3, 0, 16, 4, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FOUR = new Bounds(8, 4, 0, 16, 5, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_FIVE = new Bounds(10, 5, 0, 16, 6, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_SIX = new Bounds(12, 6, 0, 16, 7, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_SEVEN = new Bounds(14, 7, 0, 16, 8, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_ONE = new Bounds(2, 9, 0, 16, 10, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_TWO = new Bounds(4, 10, 0, 16, 11, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_THREE = new Bounds(6, 11, 0, 16, 12, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_FOUR = new Bounds(8, 12, 0, 16, 13, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_FIVE = new Bounds(10, 13, 0, 16, 14, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_SIX = new Bounds(12, 14, 0, 16, 15, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_STACKED_SEVEN = new Bounds(14, 15, 0, 16, 16, 16).getRotatedBounds();
    private static final AxisAlignedBB BOUNDING_BOX_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockBoostRamp() {
        super(Material.field_151576_e, "vehicle:boost_ramp");
        this.func_149711_c(0.8f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)(this.func_149739_a() + ".info"), (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EnumFacing facing;
        if (entityIn instanceof EntityPoweredVehicle && entityIn.func_184179_bs() != null && (facing = (EnumFacing)state.func_177229_b((IProperty)FACING)) == entityIn.func_174811_aO()) {
            EntityPoweredVehicle poweredVehicle;
            float speedMultiplier = 0.0f;
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityBoost) {
                speedMultiplier = ((TileEntityBoost)tileEntity).getSpeedMultiplier();
            }
            if (!(poweredVehicle = (EntityPoweredVehicle)entityIn).isBoosting()) {
                worldIn.func_184133_a(null, pos, ModSounds.BOOST_PAD, SoundCategory.BLOCKS, 2.0f, 0.5f);
            }
            poweredVehicle.setBoosting(true);
            poweredVehicle.setLaunching(2);
            poweredVehicle.currentSpeed = poweredVehicle.getActualMaxSpeed();
            poweredVehicle.speedMultiplier = speedMultiplier;
            poweredVehicle.field_70181_x = (double)poweredVehicle.currentSpeed * 0.5 / 20.0 + 0.1;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)STACKED) == false ? BOUNDING_BOX_BOTTOM : field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)STACKED)).booleanValue()) {
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_BASE);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_ONE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_TWO[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_THREE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_FOUR[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_FIVE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_SIX[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_STACKED_SEVEN[facing.func_176736_b()]);
        } else {
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BASE);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_ONE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_TWO[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_THREE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_FOUR[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_FIVE[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_SIX[facing.func_176736_b()]);
            BlockBoostRamp.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_SEVEN[facing.func_176736_b()]);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        state = state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false));
        state = state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false));
        if (StateHelper.getBlock(worldIn, pos, facing, StateHelper.Direction.LEFT) == this && StateHelper.getRotation(worldIn, pos, facing, StateHelper.Direction.LEFT) == StateHelper.Direction.DOWN) {
            state = state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        if (StateHelper.getBlock(worldIn, pos, facing, StateHelper.Direction.RIGHT) == this && StateHelper.getRotation(worldIn, pos, facing, StateHelper.Direction.RIGHT) == StateHelper.Direction.DOWN) {
            state = state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)STACKED) != false ? 4 : 0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)STACKED, (Comparable)Boolean.valueOf(meta / 4 == 1));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, STACKED, LEFT, RIGHT});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBoost(1.0f);
    }
}

