/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LevelGeneratorClassic
implements ILevelGenerator {
    private static final int MIN_ROOMS = 6;
    private IWorldEditor editor;
    private Random rand;
    private LevelLayout layout;
    private LevelSettings settings;
    private Coord start;

    public LevelGeneratorClassic(IWorldEditor editor, Random rand, LevelSettings settings) {
        this.editor = editor;
        this.rand = rand;
        this.layout = new LevelLayout();
        this.settings = settings;
    }

    @Override
    public void generate(Coord start) {
        this.start = start;
        ArrayList<Node> gNodes = new ArrayList<Node>();
        Node startNode = new Node(Cardinal.directions[this.rand.nextInt(Cardinal.directions.length)], start);
        gNodes.add(startNode);
        while (!this.isDone(gNodes)) {
            this.update(gNodes);
        }
        for (Node n : gNodes) {
            n.cull();
        }
        DungeonNode startDungeonNode = null;
        for (Node n : gNodes) {
            DungeonNode nToAdd = n.createNode();
            if (n == startNode) {
                startDungeonNode = nToAdd;
            }
            this.layout.addNode(nToAdd);
            this.layout.addTunnels(n.createTunnels(this.editor));
        }
        this.layout.setStartEnd(this.rand, startDungeonNode);
    }

    public void update(List<Node> nodes) {
        if (!this.full(nodes)) {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).update(nodes);
            }
        }
    }

    private boolean isDone(List<Node> nodes) {
        boolean allDone = true;
        for (Node node : nodes) {
            if (node.isDone()) continue;
            allDone = false;
        }
        return allDone || this.full(nodes);
    }

    private boolean full(List<Node> nodes) {
        return nodes.size() >= Math.max(this.settings.getNumRooms(), 6);
    }

    public void spawnNode(List<Node> nodes, Tunneler tunneler) {
        Node toAdd = new Node(tunneler.getDirection(), tunneler.getPosition());
        nodes.add(toAdd);
    }

    public boolean hasNearbyNode(List<Node> nodes, Coord pos, int min) {
        for (Node node : nodes) {
            int dist = (int)node.getPos().distance(pos);
            if (dist >= min) continue;
            return true;
        }
        return false;
    }

    @Override
    public LevelLayout getLayout() {
        return this.layout;
    }

    private class Node {
        private List<Tunneler> tunnelers = new ArrayList<Tunneler>();
        private Cardinal direction;
        private Coord pos;

        public Node(Cardinal direction, Coord pos) {
            this.direction = direction;
            this.pos = pos;
            this.spawnTunnelers();
        }

        private void spawnTunnelers() {
            if (LevelGeneratorClassic.this.start.distance(this.pos) > (double)LevelGeneratorClassic.this.settings.getRange()) {
                return;
            }
            for (Cardinal dir : Cardinal.directions) {
                if (dir.equals((Object)Cardinal.reverse(this.direction))) continue;
                this.tunnelers.add(new Tunneler(dir, new Coord(this.pos)));
            }
        }

        public void update(List<Node> nodes) {
            for (Tunneler tunneler : this.tunnelers) {
                tunneler.update(nodes);
            }
        }

        public boolean isDone() {
            for (Tunneler tunneler : this.tunnelers) {
                if (tunneler.isDone()) continue;
                return false;
            }
            return true;
        }

        public Coord getPos() {
            return new Coord(this.pos);
        }

        public Cardinal[] getEntrances() {
            ArrayList<Cardinal> c = new ArrayList<Cardinal>();
            c.add(Cardinal.reverse(this.direction));
            for (Tunneler t : this.tunnelers) {
                c.add(t.dir);
            }
            return c.toArray(new Cardinal[c.size()]);
        }

        public List<DungeonTunnel> createTunnels(IWorldEditor editor) {
            ArrayList<DungeonTunnel> tunnels = new ArrayList<DungeonTunnel>();
            for (Tunneler t : this.tunnelers) {
                tunnels.add(t.createTunnel());
            }
            return tunnels;
        }

        public DungeonNode createNode() {
            return new DungeonNode(this.getEntrances(), this.pos);
        }

        public void cull() {
            ArrayList<Tunneler> toKeep = new ArrayList<Tunneler>();
            for (Tunneler t : this.tunnelers) {
                if (!t.done) continue;
                toKeep.add(t);
            }
            this.tunnelers = toKeep;
        }
    }

    private class Tunneler {
        private boolean done = false;
        private Cardinal dir;
        private Coord start;
        private Coord end;
        private int extend;

        public Tunneler(Cardinal dir, Coord start) {
            this.dir = dir;
            this.start = new Coord(start);
            this.end = new Coord(start);
            this.extend = LevelGeneratorClassic.this.settings.getScatter() * 2;
        }

        public void update(List<Node> nodes) {
            if (this.done) {
                return;
            }
            if (LevelGeneratorClassic.this.hasNearbyNode(nodes, this.end, LevelGeneratorClassic.this.settings.getScatter())) {
                this.end.add(this.dir);
            } else if (LevelGeneratorClassic.this.rand.nextInt(this.extend) == 0) {
                LevelGeneratorClassic.this.spawnNode(nodes, this);
                this.done = true;
            } else {
                this.end.add(this.dir);
                --this.extend;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public Cardinal getDirection() {
            return this.dir;
        }

        public Coord getPosition() {
            return new Coord(this.end);
        }

        public DungeonTunnel createTunnel() {
            return new DungeonTunnel(new Coord(this.start), new Coord(this.end));
        }
    }
}

