/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntitySuperheatingElement;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BoilerUpdateProtocol
extends UpdateProtocol<SynchronizedBoilerData> {
    public static final int WATER_PER_TANK = 16000;
    public static final int STEAM_PER_TANK = 160000;

    public BoilerUpdateProtocol(TileEntityBoilerCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return BlockStateBasic.BasicBlockType.get(this.pointer.func_145831_w().func_180495_p(new BlockPos(x, y, z))) == BlockStateBasic.BasicBlockType.BOILER_CASING;
    }

    @Override
    protected boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension()).getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        return tile instanceof TileEntityPressureDisperser || tile instanceof TileEntitySuperheatingElement;
    }

    @Override
    protected boolean canForm(SynchronizedBoilerData structure) {
        if (structure.volHeight < 3) {
            return false;
        }
        HashSet<Coord4D> dispersers = new HashSet<Coord4D>();
        HashSet<Coord4D> elements = new HashSet<Coord4D>();
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(coord);
                continue;
            }
            if (!(tile instanceof TileEntitySuperheatingElement)) continue;
            structure.internalLocations.add(coord);
            elements.add(coord);
        }
        if (dispersers.isEmpty()) {
            return false;
        }
        final Coord4D initDisperser = (Coord4D)dispersers.iterator().next();
        Coord4D pos = new Coord4D(structure.renderLocation.x, initDisperser.y, structure.renderLocation.z, this.pointer.func_145831_w().field_73011_w.getDimension());
        for (int x = 1; x < structure.volLength - 1; ++x) {
            for (int z = 1; z < structure.volWidth - 1; ++z) {
                Coord4D coord4D = pos.translate(x, 0, z);
                TileEntity tile = coord4D.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (!(tile instanceof TileEntityPressureDisperser)) {
                    return false;
                }
                dispersers.remove(coord4D);
            }
        }
        if (!dispersers.isEmpty()) {
            return false;
        }
        if (elements.size() > 0) {
            structure.superheatingElements = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                @Override
                public boolean isValid(Coord4D coord) {
                    return coord.getTileEntity((IBlockAccess)BoilerUpdateProtocol.this.pointer.func_145831_w()) instanceof TileEntitySuperheatingElement;
                }
            }).calculate((Coord4D)elements.iterator().next());
        }
        if (elements.size() > structure.superheatingElements) {
            return false;
        }
        Coord4D initAir = null;
        int totalAir = 0;
        for (int x = structure.renderLocation.x; x < structure.renderLocation.x + structure.volLength; ++x) {
            for (int y = structure.renderLocation.y; y < initDisperser.y; ++y) {
                for (int z = structure.renderLocation.z; z < structure.renderLocation.z + structure.volWidth; ++z) {
                    if (!this.pointer.func_145831_w().func_175623_d(new BlockPos(x, y, z)) && !this.isViableNode(x, y, z)) continue;
                    initAir = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension());
                    ++totalAir;
                }
            }
        }
        if (initAir == null) {
            return false;
        }
        final Coord4D renderLocation = structure.renderLocation;
        final int volLength = structure.volLength;
        final int volWidth = structure.volWidth;
        structure.waterVolume = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

            @Override
            public final boolean isValid(Coord4D coord) {
                return coord.y >= renderLocation.y - 1 && coord.y < initDisperser.y && coord.x >= renderLocation.x && coord.x < renderLocation.x + volLength && coord.z >= renderLocation.z && coord.z < renderLocation.z + volWidth && (coord.isAirBlock((IBlockAccess)BoilerUpdateProtocol.this.pointer.func_145831_w()) || BoilerUpdateProtocol.this.isViableNode(coord.getPos()));
            }
        }).calculate(initAir);
        if (totalAir > structure.waterVolume) {
            return false;
        }
        int steamHeight = structure.renderLocation.y + structure.volHeight - 2 - initDisperser.y;
        structure.steamVolume = structure.volWidth * structure.volLength * steamHeight;
        structure.upperRenderLocation = new Coord4D(structure.renderLocation.x, initDisperser.y + 1, structure.renderLocation.z, this.pointer.func_145831_w().field_73011_w.getDimension());
        return true;
    }

    protected BoilerCache getNewCache() {
        return new BoilerCache();
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData();
    }

    @Override
    protected MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedBoilerData> cache, MultiblockCache<SynchronizedBoilerData> merge) {
        BoilerCache boilerCache = (BoilerCache)cache;
        BoilerCache mergeCache = (BoilerCache)merge;
        if (boilerCache.water == null) {
            boilerCache.water = mergeCache.water;
        } else if (mergeCache.water != null && boilerCache.water.isFluidEqual(mergeCache.water)) {
            boilerCache.water.amount += mergeCache.water.amount;
        }
        if (boilerCache.steam == null) {
            boilerCache.steam = mergeCache.steam;
        } else if (mergeCache.steam != null && boilerCache.steam.isFluidEqual(mergeCache.steam)) {
            boilerCache.steam.amount += mergeCache.steam.amount;
        }
        boilerCache.temperature = Math.max(boilerCache.temperature, mergeCache.temperature);
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedBoilerData)this.structureFound).waterStored != null) {
            ((SynchronizedBoilerData)this.structureFound).waterStored.amount = Math.min(((SynchronizedBoilerData)this.structureFound).waterStored.amount, ((SynchronizedBoilerData)this.structureFound).waterVolume * 16000);
        }
        if (((SynchronizedBoilerData)this.structureFound).steamStored != null) {
            ((SynchronizedBoilerData)this.structureFound).steamStored.amount = Math.min(((SynchronizedBoilerData)this.structureFound).steamStored.amount, ((SynchronizedBoilerData)this.structureFound).steamVolume * 160000);
        }
    }

    @Override
    protected void onStructureCreated(SynchronizedBoilerData structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        for (Coord4D obj : structure.locations) {
            if (!(obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityBoilerValve)) continue;
            SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
            data.location = obj;
            data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
            structure.valves.add(data);
        }
    }
}

