/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.vector;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region2;

public class Region3 {
    public Vector3 min;
    public Vector3 max;

    public Region3() {
        this(new Vector3(), new Vector3());
    }

    public Region3(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Region3(AxisAlignedBB aabb) {
        this.min = new Vector3(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        this.max = new Vector3(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.func_72330_a((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z);
    }

    public Region2 toRegion2() {
        return new Region2(this.min.toVector2(), this.max.toVector2());
    }

    public boolean isIn(Vector3 point) {
        return point.x > this.min.x && point.x < this.max.x && point.y > this.min.y && point.y < this.max.y && point.z > this.min.z && point.z < this.max.z;
    }

    public boolean isIn(Region3 region) {
        return region.max.x > this.min.x && region.min.x < this.max.x ? (region.max.y > this.min.y && region.min.y < this.max.y ? region.max.z > this.min.z && region.min.z < this.max.z : false) : false;
    }

    public void expand(Vector3 difference) {
        this.min.subtract(difference);
        this.max.add(difference);
    }

    public List getVectors() {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x = this.min.intX(); x < this.max.intX(); ++x) {
            int y = this.min.intY();
            while (x < this.max.intY()) {
                int z = this.min.intZ();
                while (x < this.max.intZ()) {
                    vectors.add(new Vector3(x, y, z));
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List getVectors(Vector3 center, int radius) {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x = this.min.intX(); x < this.max.intX(); ++x) {
            int y = this.min.intY();
            while (x < this.max.intY()) {
                int z = this.min.intZ();
                while (x < this.max.intZ()) {
                    Vector3 vector3 = new Vector3(x, y, z);
                    if (center.distanceTo(vector3) <= (double)radius) {
                        vectors.add(vector3);
                    }
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List getEntities(World world, Class entityClass) {
        return world.func_72872_a(entityClass, this.toAABB());
    }

    public List getEntitiesExlude(World world, Entity entity) {
        return world.func_72839_b(entity, this.toAABB());
    }

    public List getEntities(World world) {
        return this.getEntities(world, Entity.class);
    }
}

