/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityElectricityRunnable
extends TileEntityElectrical {
    public double prevWatts;
    public double wattsReceived = 0.0;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.prevWatts = this.wattsReceived;
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetworkHelper.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return ElectricityNetworkHelper.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack();
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage()) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 1.5f, true);
            return;
        }
        this.wattsReceived = Math.min(this.wattsReceived + electricityPack.getWatts(), this.getWattBuffer());
    }

    public double getWattBuffer() {
        return this.getRequest().getWatts() * 2.0;
    }
}

