/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class NBTFileLoader {
    public static boolean saveData(File saveDirectory, String filename, NBTTagCompound data) {
        try {
            File tempFile = new File(saveDirectory, filename + "_tmp.dat");
            File file = new File(saveDirectory, filename + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(tempFile));
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
            FMLLog.fine((String)("Saved " + filename + " NBT data file successfully."), (Object[])new Object[0]);
            return true;
        }
        catch (Exception e) {
            System.out.println("Failed to save " + filename + ".dat!");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveData(String filename, NBTTagCompound data) {
        return NBTFileLoader.saveData(NBTFileLoader.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), filename, data);
    }

    public static NBTTagCompound loadData(File saveDirectory, String filename) {
        try {
            File file = new File(saveDirectory, filename + ".dat");
            if (file.exists()) {
                FMLLog.fine((String)("Loaded " + filename + " data."), (Object[])new Object[0]);
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            FMLLog.fine((String)("Created new " + filename + " data."), (Object[])new Object[0]);
            return new NBTTagCompound();
        }
        catch (Exception e) {
            System.out.println("Failed to load " + filename + ".dat!");
            e.printStackTrace();
            return null;
        }
    }

    public static NBTTagCompound loadData(String filename) {
        return NBTFileLoader.loadData(NBTFileLoader.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), filename);
    }

    public static File getSaveDirectory(String worldName) {
        File parent = NBTFileLoader.getBaseDirectory();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            parent = new File(NBTFileLoader.getBaseDirectory(), "saves" + File.separator);
        }
        return new File(parent, worldName + File.separator);
    }

    public static File getBaseDirectory() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLClientHandler.instance().getClient();
            return Minecraft.func_71380_b();
        }
        return new File(".");
    }
}

