/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.Flag;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagWorld;
import universalelectricity.prefab.vector.Region3;

public class FlagRegion
extends FlagBase {
    public FlagWorld flagWorld;
    public String name;
    public Region3 region;
    private final List flags = new ArrayList();

    public FlagRegion(FlagWorld worldFlagData) {
        this.flagWorld = worldFlagData;
    }

    public FlagRegion(FlagWorld flagWorld, String name, Region3 region) {
        this.flagWorld = flagWorld;
        this.name = name;
        this.region = region;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74740_e();
        Vector3 startVector = Vector3.readFromNBT(nbt.func_74775_l("min"));
        Vector3 endVector = Vector3.readFromNBT(nbt.func_74775_l("max"));
        this.region = new Region3(startVector, endVector);
        NBTTagList flagList = nbt.func_74761_m("flags");
        for (int i = 0; i < flagList.func_74745_c(); ++i) {
            NBTTagCompound childNode = (NBTTagCompound)flagList.func_74743_b(i);
            try {
                Flag flag = new Flag(this);
                flag.readFromNBT(childNode);
                this.flags.add(flag);
                continue;
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read flag data: " + childNode.func_74740_e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74738_o(this.name);
        nbt.func_74782_a("min", (NBTBase)this.region.min.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("max", (NBTBase)this.region.max.writeToNBT(new NBTTagCompound()));
        NBTTagList flagList = new NBTTagList();
        for (Flag flag : this.getFlags()) {
            try {
                flagList.func_74742_a((NBTBase)flag.getNBT());
            }
            catch (Exception e) {
                System.out.println("Failed to save world flag data: " + flag.name);
                e.printStackTrace();
            }
        }
        nbt.func_74782_a("flags", (NBTBase)flagList);
    }

    public boolean containsValue(String flagName, String checkValue, Vector3 position) {
        for (Flag flag : this.flags) {
            if (!flag.name.equalsIgnoreCase(flagName) || !flag.value.equalsIgnoreCase(checkValue)) continue;
            return true;
        }
        return false;
    }

    public boolean setFlag(String flagName, String value) {
        this.removeFlag(flagName);
        if (value != null && value != "" && !this.containsFlag(flagName)) {
            return this.flags.add(new Flag(this, flagName, value));
        }
        return false;
    }

    public boolean containsFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            return true;
        }
        return false;
    }

    public boolean removeFlag(String flagName) {
        for (Flag region : this.flags) {
            if (!region.name.equalsIgnoreCase(flagName)) continue;
            this.flags.remove(region);
            return true;
        }
        return false;
    }

    public List getFlags() {
        Iterator it = this.flags.iterator();
        while (it.hasNext()) {
            Flag flag = (Flag)it.next();
            if (flag == null) {
                it.remove();
                continue;
            }
            if (flag.name != null && flag.name != "") continue;
            it.remove();
        }
        return this.flags;
    }

    public void edit(Vector3 position, int radius) {
        Vector3 minVec = new Vector3(position.intX() - radius, 0.0, position.intZ() - radius);
        Vector3 maxVec = new Vector3(position.intX() + radius, this.flagWorld.world.func_72800_K(), position.intZ() + radius);
        this.region = new Region3(minVec, maxVec);
    }
}

