/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.path;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.path.IPathCallBack;
import universalelectricity.core.path.Pathfinder;
import universalelectricity.core.vector.Vector3;

public class PathfinderAStar
extends Pathfinder {
    public IPathCallBack callBackCheck;
    public Set openSet;
    public HashMap navigationMap;
    public HashMap gScore;
    public HashMap fScore;
    public Vector3 goal;

    public PathfinderAStar(IPathCallBack callBack, Vector3 goal) {
        super(callBack);
        this.goal = goal;
    }

    @Override
    public boolean findNodes(Vector3 start) {
        this.openSet.add(start);
        this.gScore.put(start, 0.0);
        this.fScore.put(start, (Double)this.gScore.get(start) + this.getHeuristicEstimatedCost(start, this.goal));
        while (!this.openSet.isEmpty()) {
            Vector3 currentNode = null;
            double lowestFScore = 0.0;
            for (Vector3 node : this.openSet) {
                if (currentNode != null && !((Double)this.fScore.get(node) < lowestFScore)) continue;
                currentNode = node;
                lowestFScore = (Double)this.fScore.get(node);
            }
            if (currentNode == null) break;
            if (this.callBackCheck.onSearch(this, currentNode)) {
                return false;
            }
            if (currentNode.equals(this.goal)) {
                this.results = this.reconstructPath(this.navigationMap, this.goal);
                return true;
            }
            this.openSet.remove(currentNode);
            this.closedSet.add(currentNode);
            for (Vector3 neighbor : this.getNeighborNodes(currentNode)) {
                double tentativeGScore = (Double)this.gScore.get(currentNode) + currentNode.distanceTo(neighbor);
                if (this.closedSet.contains(neighbor) && tentativeGScore >= (Double)this.gScore.get(neighbor) || this.openSet.contains(neighbor) && !(tentativeGScore < (Double)this.gScore.get(neighbor))) continue;
                this.navigationMap.put(neighbor, currentNode);
                this.gScore.put(neighbor, tentativeGScore);
                this.fScore.put(neighbor, (Double)this.gScore.get(neighbor) + this.getHeuristicEstimatedCost(neighbor, this.goal));
                this.openSet.add(neighbor);
            }
        }
        return false;
    }

    @Override
    public Pathfinder reset() {
        this.openSet = new HashSet();
        this.navigationMap = new HashMap();
        return super.reset();
    }

    public Set reconstructPath(HashMap nagivationMap, Vector3 current_node) {
        HashSet<Vector3> path = new HashSet<Vector3>();
        path.add(current_node);
        if (nagivationMap.containsKey(current_node)) {
            path.addAll(this.reconstructPath(nagivationMap, (Vector3)nagivationMap.get(current_node)));
            return path;
        }
        return path;
    }

    public double getHeuristicEstimatedCost(Vector3 start, Vector3 goal) {
        return start.distanceTo(goal);
    }

    public Set getNeighborNodes(Vector3 vector) {
        if (this.callBackCheck != null) {
            return this.callBackCheck.getConnectedNodes(this, vector);
        }
        HashSet<Vector3> neighbors = new HashSet<Vector3>();
        for (int i = 0; i < 6; ++i) {
            neighbors.add(vector.clone().modifyPositionFromSide(ForgeDirection.getOrientation((int)i)));
        }
        return neighbors;
    }
}

