/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnectionProvider;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.electricity.IElectricityNetwork;
import universalelectricity.core.path.PathfinderChecker;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class ElectricityNetwork
implements IElectricityNetwork {
    private final HashMap producers = new HashMap();
    private final HashMap consumers = new HashMap();
    private final Set conductors = new HashSet();

    public ElectricityNetwork() {
    }

    public ElectricityNetwork(IConductor ... conductors) {
        this.conductors.addAll(Arrays.asList(conductors));
    }

    @Override
    public void startProducing(TileEntity tileEntity, ElectricityPack electricityPack) {
        if (tileEntity != null && electricityPack.getWatts() > 0.0) {
            this.producers.put(tileEntity, electricityPack);
        }
    }

    @Override
    public void startProducing(TileEntity tileEntity, double amperes, double voltage) {
        this.startProducing(tileEntity, new ElectricityPack(amperes, voltage));
    }

    @Override
    public boolean isProducing(TileEntity tileEntity) {
        return this.producers.containsKey(tileEntity);
    }

    @Override
    public void stopProducing(TileEntity tileEntity) {
        this.producers.remove(tileEntity);
    }

    @Override
    public void startRequesting(TileEntity tileEntity, ElectricityPack electricityPack) {
        if (tileEntity != null && electricityPack.getWatts() > 0.0) {
            this.consumers.put(tileEntity, electricityPack);
        }
    }

    @Override
    public void startRequesting(TileEntity tileEntity, double amperes, double voltage) {
        this.startRequesting(tileEntity, new ElectricityPack(amperes, voltage));
    }

    @Override
    public boolean isRequesting(TileEntity tileEntity) {
        return this.consumers.containsKey(tileEntity);
    }

    @Override
    public void stopRequesting(TileEntity tileEntity) {
        this.consumers.remove(tileEntity);
    }

    @Override
    public ElectricityPack getProduced(TileEntity ... ignoreTiles) {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        Iterator it = this.producers.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry pairs = it.next();
            if (pairs == null) continue;
            TileEntity tileEntity = (TileEntity)pairs.getKey();
            if (tileEntity == null) {
                it.remove();
                continue;
            }
            if (tileEntity.func_70320_p()) {
                it.remove();
                continue;
            }
            if (tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) {
                it.remove();
                continue;
            }
            if (ignoreTiles != null) {
                for (TileEntity ignoreTile : ignoreTiles) {
                    if (tileEntity == ignoreTile) continue block0;
                }
            }
            ElectricityPack pack = (ElectricityPack)pairs.getValue();
            if (pairs.getKey() == null || pairs.getValue() == null || pack == null) continue;
            double newWatts = totalElectricity.getWatts() + pack.getWatts();
            double newVoltage = Math.max(totalElectricity.voltage, pack.voltage);
            totalElectricity.amperes = newWatts / newVoltage;
            totalElectricity.voltage = newVoltage;
        }
        return totalElectricity;
    }

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ElectricityPack totalElectricity = this.getRequestWithoutReduction();
        totalElectricity.amperes = Math.max(totalElectricity.amperes - this.getProduced((TileEntity[])ignoreTiles).amperes, 0.0);
        return totalElectricity;
    }

    @Override
    public ElectricityPack getRequestWithoutReduction() {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        Iterator it = this.consumers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            if (pairs == null) continue;
            TileEntity tileEntity = (TileEntity)pairs.getKey();
            if (tileEntity == null) {
                it.remove();
                continue;
            }
            if (tileEntity.func_70320_p()) {
                it.remove();
                continue;
            }
            if (tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) {
                it.remove();
                continue;
            }
            ElectricityPack pack = (ElectricityPack)pairs.getValue();
            if (pack == null) continue;
            totalElectricity.amperes += pack.amperes;
            totalElectricity.voltage = Math.max(totalElectricity.voltage, pack.voltage);
        }
        return totalElectricity;
    }

    @Override
    public ElectricityPack consumeElectricity(TileEntity tileEntity) {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        try {
            ElectricityPack tileRequest = (ElectricityPack)this.consumers.get(tileEntity);
            if (this.consumers.containsKey(tileEntity) && tileRequest != null && (totalElectricity = this.getProduced(new TileEntity[0])).getWatts() > 0.0) {
                ElectricityPack totalRequest = this.getRequestWithoutReduction();
                totalElectricity.amperes *= tileRequest.amperes / totalRequest.amperes;
                int distance = this.conductors.size();
                double ampsReceived = totalElectricity.amperes - totalElectricity.amperes * totalElectricity.amperes * this.getTotalResistance() / totalElectricity.voltage;
                double voltsReceived = totalElectricity.voltage - totalElectricity.amperes * this.getTotalResistance();
                totalElectricity.amperes = ampsReceived;
                totalElectricity.voltage = voltsReceived;
                return totalElectricity;
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to consume electricity!", (Object[])new Object[0]);
            e.printStackTrace();
        }
        return totalElectricity;
    }

    @Override
    public HashMap getProducers() {
        return this.producers;
    }

    @Override
    public List getProviders() {
        ArrayList providers = new ArrayList();
        providers.addAll(this.producers.keySet());
        return providers;
    }

    @Override
    public HashMap getConsumers() {
        return this.consumers;
    }

    @Override
    public List getReceivers() {
        ArrayList receivers = new ArrayList();
        receivers.addAll(this.consumers.keySet());
        return receivers;
    }

    @Override
    public void cleanUpConductors() {
        Iterator it = this.conductors.iterator();
        while (it.hasNext()) {
            IConductor conductor = (IConductor)it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            if (((TileEntity)conductor).func_70320_p()) {
                it.remove();
                continue;
            }
            conductor.setNetwork(this);
        }
    }

    @Override
    public void refreshConductors() {
        this.cleanUpConductors();
        try {
            for (IConductor conductor : this.conductors) {
                conductor.updateAdjacentConnections();
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public double getTotalResistance() {
        double resistance = 0.0;
        for (IConductor conductor : this.conductors) {
            resistance += conductor.getResistance();
        }
        return resistance;
    }

    @Override
    public double getLowestCurrentCapacity() {
        double lowestAmp = 0.0;
        for (IConductor conductor : this.conductors) {
            if (lowestAmp != 0.0 && !(conductor.getCurrentCapcity() < lowestAmp)) continue;
            lowestAmp = conductor.getCurrentCapcity();
        }
        return lowestAmp;
    }

    @Override
    public Set getConductors() {
        return this.conductors;
    }

    @Override
    public void mergeConnection(IElectricityNetwork network) {
        if (network != null && network != this) {
            ElectricityNetwork newNetwork = new ElectricityNetwork();
            newNetwork.getConductors().addAll(this.getConductors());
            newNetwork.getConductors().addAll(network.getConductors());
            newNetwork.cleanUpConductors();
        }
    }

    @Override
    public void splitNetwork(IConnectionProvider splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getConductors().remove(splitPoint);
            for (ForgeDirection dir : ForgeDirection.values()) {
                Vector3 splitVec;
                TileEntity tileAroundSplit;
                if (dir == ForgeDirection.UNKNOWN || !this.producers.containsKey(tileAroundSplit = VectorHelper.getTileEntityFromSide(((TileEntity)splitPoint).field_70331_k, splitVec = new Vector3((TileEntity)splitPoint), dir))) continue;
                this.stopProducing(tileAroundSplit);
                this.stopRequesting(tileAroundSplit);
            }
            TileEntity[] connectedBlocks = splitPoint.getAdjacentConnections();
            for (int i = 0; i < connectedBlocks.length; ++i) {
                TileEntity connectedBlockA = connectedBlocks[i];
                if (!(connectedBlockA instanceof IConnectionProvider)) continue;
                for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                    TileEntity connectedBlockB = connectedBlocks[ii];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof IConnectionProvider)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (IConnectionProvider)connectedBlockB, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    ElectricityNetwork newNetwork = new ElectricityNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getConductors().add((IConductor)nodeTile);
                    }
                    newNetwork.cleanUpConductors();
                }
            }
        }
    }

    public String toString() {
        return "ElectricityNetwork[" + this.hashCode() + "|Wires:" + this.conductors.size() + "]";
    }
}

