/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.ICache;
import mffs.api.IProjector;
import mffs.api.modules.IModule;
import mffs.api.modules.IProjectorMode;
import mffs.base.TileEntityBase;
import mffs.block.BlockForceField;
import mffs.card.ItemCard;
import mffs.tileentity.ProjectorCalculationThread;
import mffs.tileentity.TileEntityFieldInteraction;
import mffs.tileentity.TileEntityForceField;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import universalelectricity.core.vector.Vector3;

public class TileEntityForceFieldProjector
extends TileEntityFieldInteraction
implements IProjector,
ProjectorCalculationThread.IThreadCallBack {
    protected final Set forceFields = new HashSet();

    public TileEntityForceFieldProjector() {
        this.capacityBase = 50;
        this.startModuleIndex = 1;
    }

    @Override
    public void initiate() {
        super.initiate();
        this.calculateForceField();
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityBase.TilePacketType.FXS.ordinal() && this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            Vector3 vector = new Vector3(dataStream.readInt(), dataStream.readInt(), dataStream.readInt()).add(0.5);
            Vector3 root = new Vector3(this).add(0.5);
            if (type == 1) {
                ModularForceFieldSystem.proxy.renderBeam(this.field_70331_k, root, vector, 0.6f, 0.6f, 1.0f, 40);
                ModularForceFieldSystem.proxy.renderHologramMoving(this.field_70331_k, vector, 1.0f, 1.0f, 1.0f, 50);
            } else if (type == 2) {
                ModularForceFieldSystem.proxy.renderBeam(this.field_70331_k, vector, root, 1.0f, 0.0f, 0.0f, 40);
                ModularForceFieldSystem.proxy.renderHologramMoving(this.field_70331_k, vector, 1.0f, 0.0f, 0.0f, 50);
            }
        }
    }

    @Override
    protected void calculateForceField(ProjectorCalculationThread.IThreadCallBack callBack) {
        if (!this.field_70331_k.field_72995_K && !this.isCalculating && this.getMode() != null) {
            this.forceFields.clear();
        }
        super.calculateForceField(callBack);
    }

    @Override
    public void onThreadComplete() {
        this.destroyField();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.isActive() && this.getMode() != null && this.requestFortron(this.getFortronCost(), false) >= this.getFortronCost()) {
            this.consumeCost();
            if (!this.field_70331_k.field_72995_K) {
                if (this.ticks % 10L == 0L) {
                    if (!this.isCalculated) {
                        this.calculateForceField();
                    } else {
                        this.projectField();
                    }
                }
            } else if (this.isActive()) {
                this.animation += (float)(this.getFortronCost() / 3);
            }
            if (this.ticks % 40L == 0L && this.getModuleCount(ModularForceFieldSystem.itemModuleSilence, new int[0]) <= 0) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "mffs.field", 0.6f, 1.0f - this.field_70331_k.field_73012_v.nextFloat() * 0.1f);
            }
        } else if (!this.field_70331_k.field_72995_K) {
            this.destroyField();
        }
    }

    @Override
    public int getFortronCost() {
        return super.getFortronCost() + 5;
    }

    @Override
    public float getAmplifier() {
        return Math.max(Math.min(this.getCalculatedField().size() / 1000, 10), 1);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.destroyField();
    }

    @Override
    public void projectField() {
        if (!this.field_70331_k.field_72995_K && this.isCalculated && !this.isCalculating) {
            if (this.forceFields.size() <= 0 && this.getModeStack().func_77973_b() instanceof ICache) {
                ((ICache)this.getModeStack().func_77973_b()).clearCache();
            }
            int constructionCount = 0;
            int constructionSpeed = Math.min(this.getProjectionSpeed(), Settings.MAX_FORCE_FIELDS_PER_TICK);
            HashSet fieldToBeProjected = new HashSet();
            fieldToBeProjected.addAll(this.calculatedField);
            for (IModule module : this.getModules(this.getModuleSlots())) {
                if (!module.onProject((IProjector)this, fieldToBeProjected)) continue;
                return;
            }
            block1: for (Vector3 vector : this.calculatedField) {
                Block block;
                if (fieldToBeProjected.contains(vector)) {
                    if (constructionCount > constructionSpeed) break;
                    block = Block.field_71973_m[vector.getBlockID((IBlockAccess)this.field_70331_k)];
                    if (block != null && (this.getModuleCount(ModularForceFieldSystem.itemModuleDisintegration, new int[0]) <= 0 || block.func_71934_m(this.field_70331_k, vector.intX(), vector.intY(), vector.intZ()) == -1.0f) && !block.field_72018_cp.func_76224_d() && block != Block.field_72037_aS && block != Block.field_71998_bu && block != Block.field_71962_X && block != Block.field_71961_Y && !block.isBlockReplaceable(this.field_70331_k, vector.intX(), vector.intY(), vector.intZ()) || block == ModularForceFieldSystem.blockForceField || vector.equals(new Vector3(this)) || !this.field_70331_k.func_72938_d((int)vector.intX(), (int)vector.intZ()).field_76636_d) continue;
                    for (IModule module : this.getModules(this.getModuleSlots())) {
                        int flag = module.onProject((IProjector)this, vector.clone());
                        if (flag == 1) continue block1;
                        if (flag != 2) continue;
                        break block1;
                    }
                    this.field_70331_k.func_72832_d(vector.intX(), vector.intY(), vector.intZ(), ModularForceFieldSystem.blockForceField.field_71990_ca, 0, 2);
                    TileEntity tileEntity = this.field_70331_k.func_72796_p(vector.intX(), vector.intY(), vector.intZ());
                    if (tileEntity instanceof TileEntityForceField) {
                        ((TileEntityForceField)tileEntity).setProjector(new Vector3(this));
                    }
                    this.requestFortron(1, true);
                    this.forceFields.add(vector);
                    ++constructionCount;
                    continue;
                }
                block = Block.field_71973_m[vector.getBlockID((IBlockAccess)this.field_70331_k)];
                if (block != ModularForceFieldSystem.blockForceField || ((BlockForceField)block).getProjector((IBlockAccess)this.field_70331_k, vector.intX(), vector.intY(), vector.intZ()) != this) continue;
                this.field_70331_k.func_94575_c(vector.intX(), vector.intY(), vector.intZ(), 0);
            }
        }
    }

    @Override
    public void destroyField() {
        if (!this.field_70331_k.field_72995_K && this.isCalculated && !this.isCalculating) {
            HashSet copiedSet = new HashSet();
            copiedSet.addAll(this.calculatedField);
            for (Vector3 vector : copiedSet) {
                Block block = Block.field_71973_m[vector.getBlockID((IBlockAccess)this.field_70331_k)];
                if (block != ModularForceFieldSystem.blockForceField) continue;
                this.field_70331_k.func_72832_d(vector.intX(), vector.intY(), vector.intZ(), 0, 0, 3);
            }
        }
        this.forceFields.clear();
        this.calculatedField.clear();
        this.isCalculated = false;
    }

    @Override
    public void func_70313_j() {
        this.destroyField();
        super.func_70313_j();
    }

    @Override
    public int getProjectionSpeed() {
        return 28 + 28 * this.getModuleCount(ModularForceFieldSystem.itemModuleSpeed, this.getModuleSlots());
    }

    public int func_70302_i_() {
        return 21;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0 || slotID == 1) {
            return itemStack.func_77973_b() instanceof ItemCard;
        }
        if (slotID == 2) {
            return itemStack.func_77973_b() instanceof IProjectorMode;
        }
        if (slotID >= 15) {
            return true;
        }
        return itemStack.func_77973_b() instanceof IModule;
    }

    @Override
    public Set getCards() {
        HashSet<ItemStack> cards = new HashSet<ItemStack>();
        cards.add(super.getCard());
        cards.add(this.func_70301_a(1));
        return cards;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 2), (double)(this.field_70327_n + 1));
    }

    @Override
    public long getTicks() {
        return this.ticks;
    }
}

