/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.modules.IModule;
import mffs.base.TileEntityBase;
import mffs.base.TileEntityUniversalEnergy;
import mffs.fortron.FortronHelper;
import mffs.item.card.ItemCardFrequency;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.item.IItemElectric;

public class TileEntityCoercionDeriver
extends TileEntityUniversalEnergy {
    public static final int WATTAGE = 1000;
    public static final int REQUIRED_TIME = 200;
    private static final int INITIAL_PRODUCTION = 40;
    public static final int MULTIPLE_PRODUCTION = 4;
    public static final float FORTRON_UE_RATIO = 6.0f;
    public static final int SLOT_FREQUENCY = 0;
    public static final int SLOT_BATTERY = 1;
    public static final int SLOT_FUEL = 2;
    public int processTime = 0;
    public boolean isInversed = false;

    public TileEntityCoercionDeriver() {
        this.capacityBase = 30;
        this.startModuleIndex = 3;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isDisabled() && this.isActive()) {
                if (this.isInversed && Settings.ENABLE_ELECTRICITY) {
                    double watts = Math.min((float)this.getFortronEnergy() * 6.0f, 1000.0f);
                    ElectricityPack remainder = this.produce(watts);
                    double electricItemGiven = 0.0;
                    if (remainder.getWatts() > 0.0) {
                        electricItemGiven = ElectricItemHelper.chargeItem(this.func_70301_a(1), remainder.getWatts(), this.getVoltage());
                    }
                    this.requestFortron((int)((watts - (remainder.getWatts() - electricItemGiven)) / 6.0), true);
                } else {
                    this.wattsReceived += ElectricItemHelper.dechargeItem(this.func_70301_a(1), 1000.0, this.getVoltage());
                    if (this.wattsReceived >= 1000.0 || !Settings.ENABLE_ELECTRICITY && this.func_94041_b(2, this.func_70301_a(2))) {
                        int production = this.getProductionRate();
                        this.fortronTank.fill(FortronHelper.getFortron(production + this.field_70331_k.field_73012_v.nextInt(production)), true);
                        if (this.processTime == 0 && this.func_94041_b(2, this.func_70301_a(2))) {
                            this.func_70298_a(2, 1);
                            this.processTime = 200 * Math.max(this.getModuleCount(ModularForceFieldSystem.itemModuleSpeed, new int[0]) / 20, 1);
                        }
                        if (this.processTime > 0) {
                            --this.processTime;
                            if (this.processTime < 1) {
                                this.processTime = 0;
                            }
                        } else {
                            this.processTime = 0;
                        }
                        this.wattsReceived -= 1000.0;
                    }
                }
            }
        } else if (this.isActive()) {
            this.animation += 1.0f;
        }
    }

    public int getProductionRate() {
        if (!this.isDisabled() && this.isActive() && !this.isInversed) {
            int production = 40;
            if (this.processTime > 0) {
                production *= 4;
            }
            return production;
        }
        return 0;
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public ElectricityPack getRequest() {
        if (this.canConsume()) {
            return new ElectricityPack(1000.0 / this.getVoltage(), this.getVoltage());
        }
        return super.getRequest();
    }

    public boolean canConsume() {
        if (this.isActive() && !this.isInversed) {
            return FortronHelper.getAmount(this.fortronTank) < this.fortronTank.getCapacity();
        }
        return false;
    }

    @Override
    public List getPacketUpdate() {
        LinkedList<Comparable<Boolean>> objects = new LinkedList<Comparable<Boolean>>();
        objects.addAll(super.getPacketUpdate());
        objects.add(Boolean.valueOf(this.isInversed));
        objects.add(Double.valueOf(this.wattsReceived));
        return objects;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityBase.TilePacketType.DESCRIPTION.ordinal()) {
            this.isInversed = dataStream.readBoolean();
            this.wattsReceived = dataStream.readDouble();
        } else if (packetID == TileEntityBase.TilePacketType.TOGGLE_MODE.ordinal()) {
            this.isInversed = !this.isInversed;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.processTime = nbt.func_74762_e("processTime");
        this.isInversed = nbt.func_74767_n("isInversed");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74757_a("isInversed", this.isInversed);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack != null) {
            if (slotID >= this.startModuleIndex) {
                return itemStack.func_77973_b() instanceof IModule;
            }
            switch (slotID) {
                case 0: {
                    return itemStack.func_77973_b() instanceof ItemCardFrequency;
                }
                case 1: {
                    return itemStack.func_77973_b() instanceof IItemElectric;
                }
                case 2: {
                    return itemStack.func_77969_a(new ItemStack(Item.field_77756_aW, 1, 4)) || itemStack.func_77969_a(new ItemStack(Item.field_94583_ca));
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }
}

