/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.card.ICardIdentification;
import mffs.api.security.IBiometricIdentifier;
import mffs.api.security.Permission;
import mffs.base.TileEntityBase;
import mffs.base.TileEntityFrequency;
import mffs.item.card.ItemCardFrequency;
import net.minecraft.item.ItemStack;

public class TileEntityBiometricIdentifier
extends TileEntityFrequency
implements IBiometricIdentifier {
    public static final int SLOT_COPY = 12;

    @Override
    public boolean isAccessGranted(String username, Permission permission) {
        if (!this.isActive()) {
            return true;
        }
        if (ModularForceFieldSystem.proxy.isOp(username) && Settings.OP_OVERRIDE) {
            return true;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ICardIdentification) || !username.equalsIgnoreCase(((ICardIdentification)itemStack.func_77973_b()).getUsername(itemStack)) || !((ICardIdentification)itemStack.func_77973_b()).hasPermission(itemStack, permission)) continue;
            return true;
        }
        return username.equalsIgnoreCase(this.getOwner());
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityBase.TilePacketType.TOGGLE_MODE.ordinal()) {
            if (this.getManipulatingCard() != null) {
                ICardIdentification idCard = (ICardIdentification)this.getManipulatingCard().func_77973_b();
                int id = dataStream.readInt();
                Permission permission = Permission.getPermission(id);
                if (permission != null) {
                    if (!idCard.hasPermission(this.getManipulatingCard(), permission)) {
                        idCard.addPermission(this.getManipulatingCard(), permission);
                    } else {
                        idCard.removePermission(this.getManipulatingCard(), permission);
                    }
                } else {
                    ModularForceFieldSystem.LOGGER.severe("Error handling security station permission packet: " + id + " - " + permission);
                }
            }
        } else if (packetID == TileEntityBase.TilePacketType.STRING.ordinal() && this.getManipulatingCard() != null) {
            ICardIdentification idCard = (ICardIdentification)this.getManipulatingCard().func_77973_b();
            idCard.setUsername(this.getManipulatingCard(), dataStream.readUTF());
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack.func_77973_b() instanceof ItemCardFrequency;
        }
        return itemStack.func_77973_b() instanceof ICardIdentification;
    }

    @Override
    public String getOwner() {
        ItemStack itemStack = this.func_70301_a(2);
        if (itemStack != null && itemStack.func_77973_b() instanceof ICardIdentification) {
            return ((ICardIdentification)itemStack.func_77973_b()).getUsername(itemStack);
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.getManipulatingCard() != null && this.func_70301_a(12) != null && this.func_70301_a(12).func_77973_b() instanceof ICardIdentification) {
            ICardIdentification masterCard = (ICardIdentification)this.getManipulatingCard().func_77973_b();
            ICardIdentification copyCard = (ICardIdentification)this.func_70301_a(12).func_77973_b();
            for (Permission permission : Permission.getPermissions()) {
                if (masterCard.hasPermission(this.getManipulatingCard(), permission)) {
                    copyCard.addPermission(this.func_70301_a(12), permission);
                    continue;
                }
                copyCard.removePermission(this.func_70301_a(12), permission);
            }
        }
    }

    public int func_70302_i_() {
        return 13;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public ItemStack getManipulatingCard() {
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() instanceof ICardIdentification) {
            return this.func_70301_a(1);
        }
        return null;
    }

    @Override
    public void setActive(boolean flag) {
        if (this.getOwner() != null || !flag) {
            super.setActive(flag);
        }
    }

    @Override
    public Set getBiometricIdentifiers() {
        HashSet<TileEntityBiometricIdentifier> set = new HashSet<TileEntityBiometricIdentifier>();
        set.add(this);
        return set;
    }
}

