/*
 * Decompiled with CFR 0.152.
 */
package mffs.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mffs.ModularForceFieldSystem;
import mffs.api.card.ICardIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector2;

@SideOnly(value=Side.CLIENT)
public class RenderIDCard
implements IItemRenderer {
    private Minecraft mc = Minecraft.func_71410_x();

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        if (itemStack.func_77973_b() instanceof ICardIdentification) {
            ICardIdentification card = (ICardIdentification)itemStack.func_77973_b();
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            this.transform(type);
            this.renderItemIcon(ModularForceFieldSystem.itemCardID.getIcon(itemStack, 0));
            if (type != IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0E-4f);
            }
            this.renderPlayerFace(this.getSkin(card.getUsername(itemStack)));
            if (type != IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.002f);
                this.renderItemIcon(ModularForceFieldSystem.itemCardID.getIcon(itemStack, 0));
            }
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
    }

    private void transform(IItemRenderer.ItemRenderType type) {
        float scale = 0.0625f;
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
            GL11.glTranslatef((float)20.0f, (float)-16.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)20.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Minecraft.func_71386_F() / 12.0f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-8.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)(2.0 * Math.sin((double)Minecraft.func_71386_F() / 512.0 % 360.0)), (double)0.0);
        }
    }

    private int getSkin(String name) {
        try {
            String skin = "http://skins.minecraft.net/MinecraftSkins/" + name + ".png";
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71446_o.func_82773_c(skin)) {
                mc.field_71446_o.func_78356_a(skin, (IImageBuffer)new ImageBufferDownload());
            }
            return mc.field_71446_o.func_78350_a(skin, "/mob/char.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void renderPlayerFace(int texID) {
        Vector2 translation = new Vector2(9.0, 5.0);
        int xSize = 4;
        int ySize = 4;
        int topLX = translation.intX();
        int topRX = translation.intX() + xSize;
        int botLX = translation.intX();
        int botRX = translation.intX() + xSize;
        int topLY = translation.intY();
        int topRY = translation.intY();
        int botLY = translation.intY() + ySize;
        int botRY = translation.intY() + ySize;
        GL11.glBindTexture((int)3553, (int)texID);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.125f, (float)0.25f);
        GL11.glVertex2f((float)topLX, (float)topLY);
        GL11.glTexCoord2f((float)0.125f, (float)0.5f);
        GL11.glVertex2f((float)botLX, (float)botLY);
        GL11.glTexCoord2f((float)0.25f, (float)0.5f);
        GL11.glVertex2f((float)botRX, (float)botRY);
        GL11.glTexCoord2f((float)0.25f, (float)0.25f);
        GL11.glVertex2f((float)topRX, (float)topRY);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.625f, (float)0.25f);
        GL11.glVertex2f((float)topLX, (float)topLY);
        GL11.glTexCoord2f((float)0.625f, (float)0.5f);
        GL11.glVertex2f((float)botLX, (float)botLY);
        GL11.glTexCoord2f((float)0.75f, (float)0.5f);
        GL11.glVertex2f((float)botRX, (float)botRY);
        GL11.glTexCoord2f((float)0.75f, (float)0.25f);
        GL11.glVertex2f((float)topRX, (float)topRY);
        GL11.glEnd();
    }

    private void renderItemIcon(Icon icon) {
        Minecraft.func_71410_x().field_71446_o.func_98187_b("/gui/items.png");
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)icon.func_94209_e(), (float)icon.func_94206_g());
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)icon.func_94209_e(), (float)icon.func_94210_h());
        GL11.glVertex2f((float)0.0f, (float)16.0f);
        GL11.glTexCoord2f((float)icon.func_94212_f(), (float)icon.func_94210_h());
        GL11.glVertex2f((float)16.0f, (float)16.0f);
        GL11.glTexCoord2f((float)icon.func_94212_f(), (float)icon.func_94206_g());
        GL11.glVertex2f((float)16.0f, (float)0.0f);
        GL11.glEnd();
    }

    private void renderItem3D(EntityLiving par1EntityLiving, ItemStack par2ItemStack, int par3) {
        Icon icon = par1EntityLiving.func_70620_b(par2ItemStack, par3);
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        if (par2ItemStack.func_94608_d() == 0) {
            this.mc.field_71446_o.func_98187_b("/terrain.png");
        } else {
            this.mc.field_71446_o.func_98187_b("/gui/items.png");
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
        float f6 = 1.5f;
        GL11.glScalef((float)f6, (float)f6, (float)f6);
        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94213_j(), (int)icon.func_94208_k(), (float)0.0625f);
        if (par2ItemStack != null && par2ItemStack.func_77962_s() && par3 == 0) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            this.mc.field_71446_o.func_98187_b("%blur%/misc/glint.png");
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }
}

